/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.util.Random;
import org.unicode.cldr.draft.GapString;
import org.unicode.cldr.icu.dev.test.TestFmwk;
import org.unicode.cldr.util.Timer;

public class GapStringTest
extends TestFmwk {
    private static final int ITERATIONS = 100000;
    private static final int RANDOM_STRING_LENGTH = 9;
    static DecimalFormat percent = (DecimalFormat)NumberFormat.getPercentInstance();
    private static Random random = new Random(0L);

    public static void main(String[] args) {
        new GapStringTest().run(args);
    }

    public static void TestCorrectness() {
        GapString a = new GapString();
        StringBuilder b = new StringBuilder();
        block7: for (int iteration = 0; iteration < 100000; ++iteration) {
            int randomPos = random.nextInt(b.length() + 1);
            switch (random.nextInt(4)) {
                case 0: {
                    int randomEnd = randomPos + random.nextInt(b.length() - randomPos + 1);
                    b.delete(randomPos, randomEnd);
                    a.delete(randomPos, randomEnd);
                    GapStringTest.assertEqual(a, b);
                    continue block7;
                }
                case 1: {
                    char randomChar = (char)(97 + random.nextInt(26));
                    b.insert(randomPos, randomChar);
                    a.insert(randomPos, randomChar);
                    GapStringTest.assertEqual(a, b);
                    continue block7;
                }
                case 2: {
                    String randomString = GapStringTest.getRandomString(9);
                    b.insert(randomPos, randomString);
                    a.insert(randomPos, randomString);
                    GapStringTest.assertEqual(a, b);
                    continue block7;
                }
                case 3: {
                    StringBuffer randomStringBuffer = new StringBuffer(GapStringTest.getRandomString(9));
                    b.insert(randomPos, randomStringBuffer);
                    a.insert(randomPos, randomStringBuffer);
                    GapStringTest.assertEqual(a, b);
                    continue block7;
                }
                case 4: {
                    String randomString = GapStringTest.getRandomString(9);
                    b.append(randomString);
                    a.append(randomString);
                    GapStringTest.assertEqual(a, b);
                }
            }
        }
    }

    public static void TestTimeDeleteInsert() {
        GapStringTest.checkTime(TimingStyle.fixed);
    }

    public static void TestTimeRandomDeleteInsert() {
        GapStringTest.checkTime(TimingStyle.randomStart);
    }

    public static void TestTimeAppend() {
        GapStringTest.checkTime(TimingStyle.append);
    }

    private static void checkTime(TimingStyle timingStyle) {
        GapString a = new GapString("abcdefghijklmonpqrstuvwxyz");
        StringBuilder b = new StringBuilder("abcdefghijklmonpqrstuvwxyz");
        double[] randomStarts = new double[256];
        double[] randomInserts = new double[256];
        if (timingStyle == TimingStyle.randomStart) {
            for (int i = 0; i < randomStarts.length; ++i) {
                randomStarts[i] = random.nextDouble();
                randomInserts[i] = random.nextDouble();
            }
        }
        Timer timer = new Timer();
        timer.start();
        block9: for (int i = 0; i < 100000; ++i) {
            switch (timingStyle) {
                case append: {
                    a.append("!@#$%X");
                    continue block9;
                }
                case randomStart: 
                case fixed: {
                    int deletePos = 5;
                    int insertPos = 5;
                    if (timingStyle == TimingStyle.randomStart) {
                        int length = a.length() - 5;
                        deletePos = (int)((double)length * randomStarts[i & 0xFF]);
                        insertPos = (int)((double)length * randomInserts[i & 0xFF]);
                    }
                    a.delete(deletePos, deletePos + 5);
                    a.insert(insertPos, "!@#$%X");
                }
            }
        }
        timer.stop();
        long gapDuration = timer.getDuration();
        timer.start();
        block10: for (int i = 0; i < 100000; ++i) {
            switch (timingStyle) {
                case append: {
                    b.append("!@#$%X");
                    continue block10;
                }
                case randomStart: 
                case fixed: {
                    int deletePos = 5;
                    int insertPos = 5;
                    if (timingStyle == TimingStyle.randomStart) {
                        int length = b.length() - 5;
                        deletePos = (int)((double)length * randomStarts[i & 0xFF]);
                        insertPos = (int)((double)length * randomInserts[i & 0xFF]);
                    }
                    b.delete(deletePos, deletePos + 5);
                    b.insert(insertPos, "!@#$%X");
                }
            }
        }
        timer.stop();
        long builderDuration = timer.getDuration();
        GapStringTest.assertEqual(a, b);
        System.out.println("\tGap - Builder% =\t" + percent.format((double)gapDuration * 1.0 / (double)builderDuration - 1.0));
    }

    private static String getRandomString(int maxLength) {
        StringBuilder result = new StringBuilder();
        for (int i = random.nextInt(maxLength); i >= 0; --i) {
            result.append((char)(97 + random.nextInt(26)));
        }
        return result.toString();
    }

    private static void assertEqual(CharSequence a, CharSequence b) {
        if (!a.equals(b)) {
            a.equals(b);
            throw new IllegalArgumentException();
        }
        if (!b.toString().equals(a.toString())) {
            b.equals(a.toString());
            throw new IllegalArgumentException();
        }
    }

    static {
        percent.setMaximumFractionDigits(6);
        percent.setPositivePrefix("+");
    }

    static enum TimingStyle {
        fixed,
        randomStart,
        append;

    }
}

