/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.SimpleXMLSource;

public class CLDRTreeWriter
implements AutoCloseable {
    private final Set<CLDRLocale> locales = new TreeSet<CLDRLocale>();
    private final Set<CLDRLocale> removed = new TreeSet<CLDRLocale>();
    private final String path;

    public CLDRTreeWriter(String forPath) {
        this.path = forPath;
    }

    public void write(CLDRFile f) throws IOException {
        String locale = f.getLocaleID();
        CLDRLocale loc = CLDRLocale.getInstance(locale);
        try (PrintWriter pw = FileUtilities.openUTF8Writer(this.path, locale + ".xml");){
            f.write(pw);
            this.locales.add(loc);
            this.removed.remove(loc);
            System.out.println("# Wrote: " + this.path + "/" + locale + ".xml");
        }
    }

    public void delete(String locale) {
        this.delete(CLDRLocale.getInstance(locale));
    }

    public File getFile(CLDRLocale locale) {
        return new File(this.path, String.valueOf(locale) + ".xml");
    }

    public void delete(CLDRLocale locale) {
        this.locales.remove(locale);
        this.removed.add(locale);
        System.out.println("# Removed: " + this.path + "/" + String.valueOf(locale) + ".xml");
    }

    @Override
    public void close() throws IOException {
        TreeSet<CLDRLocale> missingParents = new TreeSet<CLDRLocale>();
        for (CLDRLocale locale : this.locales) {
            this.ensureParentExists(locale.getParent(), missingParents);
        }
        for (CLDRLocale locale : missingParents) {
            CLDRFile wasMissing = new CLDRFile(new SimpleXMLSource(locale.getBaseName()));
            System.out.println("# Writing missing parent: " + this.getFile(locale).getPath());
            this.write(wasMissing);
        }
        for (CLDRLocale locale : this.removed) {
            this.getFile(locale).deleteOnExit();
        }
        System.out.println("# for " + this.path + " - wrote " + this.locales.size() + " and removed " + this.removed.size());
    }

    private void ensureParentExists(CLDRLocale locale, Set<CLDRLocale> missingParents) throws IOException {
        if (locale == null || this.locales.contains(locale)) {
            return;
        }
        if (this.getFile(locale).canRead() && !this.removed.contains(locale)) {
            return;
        }
        missingParents.add(locale);
        this.ensureParentExists(locale.getParent(), missingParents);
    }
}

