/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathDescriptionParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class PathDescription {
    public static final String pathDescriptionFileName = "PathDescriptions.md";
    public static final String pathDescriptionHintsFileName = "PathDescriptionHints.md";
    private static final String pathDescriptionString = CldrUtility.getUTF8Data("PathDescriptions.md").lines().collect(Collectors.joining("\n"));
    private static final String pathDescriptionHintsString = CldrUtility.getUTF8Data("PathDescriptionHints.md").lines().collect(Collectors.joining("\n"));
    private static final Logger logger = Logger.getLogger(PathDescription.class.getName());
    public static final Set<String> EXTRA_LANGUAGES = new TreeSet<String>(Arrays.asList("ach|af|ak|ak|am|ar|az|be|bem|bg|bh|bn|br|bs|ca|chr|ckb|co|crs|cs|cy|da|de|de_AT|de_CH|ee|el|en|en_AU|en_CA|en_GB|en_US|eo|es|es_419|es_ES|et|eu|fa|fi|fil|fo|fr|fr_CA|fr_CH|fy|ga|gaa|gd|gl|gn|gsw|gu|ha|haw|he|hi|hr|ht|hu|hy|ia|id|ig|io|is|it|ja|jv|ka|kg|kk|km|kn|ko|kri|ku|ky|la|lg|ln|lo|loz|lt|lua|lv|mfe|mg|mi|mk|ml|mn|mr|ms|mt|my|nb|ne|nl|nl_BE|nn|no|nso|ny|nyn|oc|om|or|pa|pcm|pl|ps|pt|pt_BR|pt_PT|qu|rm|rn|ro|ro|ro_MD|ru|rw|sd|si|sk|sl|sn|so|sq|sr|sr_Latn|sr_ME|st|su|sv|sw|ta|te|tg|th|ti|tk|tlh|tn|to|tr|tt|tum|ug|uk|und|ur|uz|vi|wo|xh|yi|yo|zh|zh_Hans|zh_Hant|zh_HK|zu|zxx".split("\\|")));
    private static final Pattern METAZONE_PATTERN = Pattern.compile("//ldml/dates/timeZoneNames/metazone\\[@type=\"([^\"]*)\"]/(.*)/(.*)");
    private static final Pattern STAR_ATTRIBUTE_PATTERN = PatternCache.get("=\"([^\"]*)\"");
    private static final StandardCodes STANDARD_CODES = StandardCodes.make();
    private static final Map<String, String> ZONE2COUNTRY = PathDescription.STANDARD_CODES.zoneParser.getZoneToCountry();
    private static RegexLookup<Pair<String, String>> pathHandling = null;
    private static RegexLookup<Pair<String, String>> pathHintsHandling = null;
    private static String references = null;
    private final CLDRFile english;
    private final Map<String, String> extras;
    private final ErrorHandling errorHandling;
    private final Map<String, List<Set<String>>> starredPaths;
    private final Set<String> allMetazones;
    private final Matcher metazoneMatcher = METAZONE_PATTERN.matcher("");
    private final Output<String[]> pathArguments = new Output();
    private final EnumSet<Status> status = EnumSet.noneOf(Status.class);
    public static final String MISSING_DESCRIPTION = "Before translating, please see https://cldr.unicode.org/translation/.";

    static String getBigString(String fileName) {
        switch (fileName) {
            case "PathDescriptions.md": {
                return pathDescriptionString;
            }
            case "PathDescriptionHints.md": {
                return pathDescriptionHintsString;
            }
        }
        throw new IllegalArgumentException();
    }

    public static RegexLookup<Pair<String, String>> getPathHandling() {
        if (pathHandling == null) {
            PathDescriptionParser parser = new PathDescriptionParser();
            pathHandling = parser.parse(pathDescriptionFileName);
            references = parser.getReferences();
        }
        return pathHandling;
    }

    private static RegexLookup<Pair<String, String>> getPathHintsHandling() {
        if (pathHintsHandling == null) {
            PathDescriptionParser hintsParser = new PathDescriptionParser();
            pathHintsHandling = hintsParser.parse(pathDescriptionHintsFileName);
        }
        return pathHintsHandling;
    }

    public PathDescription(SupplementalDataInfo supplementalDataInfo, CLDRFile english, Map<String, String> extras, Map<String, List<Set<String>>> starredPaths, ErrorHandling errorHandling) {
        this.english = english;
        this.extras = extras == null ? new HashMap() : extras;
        this.starredPaths = starredPaths == null ? new HashMap() : starredPaths;
        this.allMetazones = supplementalDataInfo.getAllMetazones();
        this.errorHandling = errorHandling;
    }

    public EnumSet<Status> getStatus() {
        return this.status;
    }

    public String getRawDescription(String path, Object context) {
        this.status.clear();
        Pair<String, String> entry = PathDescription.getPathHandling().get(path, context, this.pathArguments);
        if (entry == null) {
            return null;
        }
        return entry.getSecond();
    }

    public String getHintRawDescription(String path, Object context) {
        this.status.clear();
        Pair<String, String> entry = PathDescription.getPathHintsHandling().get(path, context, this.pathArguments);
        if (entry == null) {
            return null;
        }
        return entry.getSecond();
    }

    public String getRawDescription(String path, Object context, Output<RegexLookup.Finder> matcherFound, Set<String> failures) {
        this.status.clear();
        Pair<String, String> entry = PathDescription.getPathHandling().get(path, context, this.pathArguments, matcherFound, failures);
        if (entry == null) {
            return null;
        }
        return entry.getSecond();
    }

    public String getDescription(String path, String value, Object context) {
        String description;
        String markdown;
        this.status.clear();
        Pair<String, String> entry = PathDescription.getPathHandling().get(path, context, this.pathArguments);
        if (entry == null) {
            markdown = MISSING_DESCRIPTION;
            description = null;
        } else {
            description = entry.getFirst();
            markdown = entry.getSecond();
        }
        if (description == null || description.isEmpty()) {
            description = MISSING_DESCRIPTION;
        } else if (description.startsWith("SKIP")) {
            this.status.add(Status.SKIP);
            if (this.errorHandling == ErrorHandling.SKIP) {
                return null;
            }
        }
        if (value == null) {
            String xpath = this.extras.get(path);
            if (xpath != null) {
                value = this.english.getStringValue(xpath);
            } else if (path.contains("/metazone") && this.metazoneMatcher.reset(path).matches()) {
                String name = this.metazoneMatcher.group(1);
                String type = this.metazoneMatcher.group(3);
                value = name.replace('_', ' ') + (type.equals("generic") ? "" : (type.equals("daylight") ? " Summer" : " Winter")) + " Time";
            }
            if (value == null) {
                this.status.add(Status.NULL_VALUE);
                if (this.errorHandling == ErrorHandling.SKIP) {
                    return null;
                }
            }
        }
        if (value != null && ((String)value).isEmpty()) {
            this.status.add(Status.EMPTY_CONTENT);
            if (this.errorHandling == ErrorHandling.SKIP) {
                return null;
            }
        }
        List<String> attributes = this.addStarredInfo(this.starredPaths, path);
        if (description.startsWith("ROOT")) {
            String type = description.substring(4).trim();
            boolean isMetazone = type.equals("metazone");
            Object code = attributes.get(0);
            boolean isRootCode = PathDescription.isRootCode((String)code, this.allMetazones, type, isMetazone);
            if (!isRootCode) {
                this.status.add(Status.NOT_REQUIRED);
                if (this.errorHandling == ErrorHandling.SKIP) {
                    return null;
                }
            }
            if (isMetazone) {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String daylightType = parts.getElement(-1);
                daylightType = daylightType.equals("daylight") ? "summer" : (daylightType.equals("standard") ? "winter" : daylightType);
                String length = parts.getElement(-2);
                length = length.equals("long") ? "" : "abbreviated ";
                code = (String)code + ", " + length + daylightType + " form";
            } else if (type.equals("timezone")) {
                String countryName;
                String country = ZONE2COUNTRY.get(code);
                int lastSlash = ((String)code).lastIndexOf(47);
                String codeName = lastSlash < 0 ? code : ((String)code).substring(lastSlash + 1).replace('_', ' ');
                boolean found = false;
                if ("001".equals(country)) {
                    code = "the timezone \u201c" + codeName + "\u201d";
                    found = true;
                } else if (country != null && (countryName = this.english.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, country)) != null) {
                    code = !codeName.equals(countryName) ? "the city \u201c" + codeName + "\u201d (in " + countryName + ")" : "the country \u201c" + codeName + "\u201d";
                    found = true;
                }
                if (!found) {
                    logger.warning("Missing country for timezone " + (String)code);
                }
            }
            markdown = MessageFormat.format(MessageFormat.autoQuoteApostrophe(markdown), code);
        } else if (path.contains("exemplarCity")) {
            String regionCode = ZONE2COUNTRY.get(attributes.get(0));
            String englishRegionName = this.english.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, regionCode);
            markdown = MessageFormat.format(MessageFormat.autoQuoteApostrophe(markdown), englishRegionName);
        } else if (entry != null) {
            markdown = MessageFormat.format(MessageFormat.autoQuoteApostrophe(markdown), (Object[])this.pathArguments.value);
        }
        return markdown + "\n" + references;
    }

    private static boolean isRootCode(String code, Set<String> allMetazones, String type, boolean isMetazone) {
        boolean isRootCode;
        Set<String> codes = isMetazone ? allMetazones : (type.equals("timezone") ? PathDescription.STANDARD_CODES.zoneParser.getZoneData().keySet() : STANDARD_CODES.getSurveyToolDisplayCodes(type));
        boolean bl = isRootCode = codes.contains(code) || code.contains("_");
        if (!isRootCode && type.equals("language") && EXTRA_LANGUAGES.contains(code)) {
            isRootCode = true;
        }
        return isRootCode;
    }

    private List<String> addStarredInfo(Map<String, List<Set<String>>> starredPaths, String path) {
        Matcher starAttributeMatcher = STAR_ATTRIBUTE_PATTERN.matcher(path);
        StringBuilder starredPath = new StringBuilder();
        ArrayList<String> attributes = new ArrayList<String>();
        int lastEnd = 0;
        while (starAttributeMatcher.find()) {
            int start = starAttributeMatcher.start(1);
            int end = starAttributeMatcher.end(1);
            starredPath.append(path, lastEnd, start);
            starredPath.append(".*");
            attributes.add(path.substring(start, end));
            lastEnd = end;
        }
        starredPath.append(path.substring(lastEnd));
        String starredPathString = starredPath.toString().intern();
        List attributeList = starredPaths.computeIfAbsent(starredPathString, k -> new ArrayList());
        int i = 0;
        for (String attribute : attributes) {
            Set<String> subset;
            if (attributeList.size() <= i) {
                subset = new TreeSet<String>();
                ((TreeSet)subset).add(attribute);
                attributeList.add(subset);
            } else {
                subset = (Set)attributeList.get(i);
                subset.add(attribute);
            }
            ++i;
        }
        return attributes;
    }

    public static enum Status {
        SKIP,
        NULL_VALUE,
        EMPTY_CONTENT,
        NOT_REQUIRED;

    }

    public static enum ErrorHandling {
        SKIP,
        CONTINUE;

    }
}

