/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;

public class SinglePropertyMap<T>
implements PropertyMap {
    private final PropertyId<T> pid;
    private final T value;

    private SinglePropertyMap(PropertyId<T> propertyId, T t2) {
        if (!propertyId.getValueClass().isInstance(t2)) {
            if (t2 == null) {
                throw new NullPointerException();
            }
            throw new ClassCastException();
        }
        this.pid = propertyId;
        this.value = t2;
    }

    public <V> V get(PropertyId<V> propertyId) {
        if (propertyId != this.pid) {
            return null;
        }
        return propertyId.getValueClass().cast(this.value);
    }

    @Override
    public boolean contains(PropertyId<?> propertyId) {
        return propertyId == this.pid;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public PropertyId<?> getKey(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.pid;
    }

    public static <T> SinglePropertyMap newInstance(PropertyId<T> propertyId, T t2) {
        return new SinglePropertyMap<T>(propertyId, t2);
    }
}

