/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

public final class CodePoints {
    private static final int SUPPLEMENTAL_OFFSET = 56613888;
    private CharSequence buffer;
    private int length;
    private int position = 0;
    private int codePoint;

    public CodePoints(CharSequence s2) {
        this.buffer = s2;
        this.length = s2.length();
    }

    public void reset(CharSequence s2) {
        this.buffer = s2;
        this.length = s2.length();
        this.position = 0;
    }

    public void reset() {
        this.position = 0;
    }

    public boolean next() {
        char trail;
        int cp;
        if (this.position < 0 || this.position >= this.length) {
            this.codePoint = 65535;
            return false;
        }
        if ((cp = this.buffer.charAt(this.position++)) >= 55296 && cp <= 56319 && this.position < this.length && (trail = this.buffer.charAt(this.position)) >= '\udc00' && trail <= '\udfff') {
            cp = (cp << 10) + trail - 56613888;
            ++this.position;
        }
        this.codePoint = cp;
        return true;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public String toString() {
        return String.valueOf(this.buffer.subSequence(0, this.position)) + "|||" + String.valueOf(this.buffer.subSequence(this.position, this.buffer.length()));
    }

    public static int[] full(CharSequence s2) {
        int len = s2.length();
        int[] result = new int[len];
        int pos = 0;
        int i = 0;
        while (i < len) {
            int last;
            int cp;
            if ((cp = s2.charAt(i++)) >= 56320 && cp < 57343 && pos > 0 && (last = result[pos - 1]) >= 55296 && last <= 56319) {
                cp += (last << 10) - 56613888;
            }
            int n = --pos;
            ++pos;
            result[n] = cp;
        }
        if (pos < len) {
            int[] result2 = new int[pos];
            System.arraycopy(result, 0, result2, 0, pos);
            result = result2;
        }
        return result;
    }
}

