/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.unicode.cldr.posix.POSIXVariant;
import org.unicode.cldr.util.CLDRFile;

public class POSIXUtilities {
    private static UnicodeSet repertoire = new UnicodeSet(0, 0x10FFFF);
    private static CLDRFile char_fallbk;
    private static Map<Integer, String> controlCodeNames;

    private static void initControlCodeNames() {
        controlCodeNames.put(0, "NULL");
        controlCodeNames.put(1, "START_OF_HEADING");
        controlCodeNames.put(2, "START_OF_TEXT");
        controlCodeNames.put(3, "END_OF_TEXT");
        controlCodeNames.put(4, "END_OF_TRANSMISSION");
        controlCodeNames.put(5, "ENQUIRY");
        controlCodeNames.put(6, "ACKNOWLEDGE");
        controlCodeNames.put(7, "ALERT");
        controlCodeNames.put(8, "BACKSPACE");
        controlCodeNames.put(9, "tab");
        controlCodeNames.put(10, "newline");
        controlCodeNames.put(11, "vertical-tab");
        controlCodeNames.put(12, "form-feed");
        controlCodeNames.put(13, "carriage-return");
        controlCodeNames.put(14, "SHIFT_OUT");
        controlCodeNames.put(15, "SHIFT_IN");
        controlCodeNames.put(16, "DATA_LINK_ESCAPE");
        controlCodeNames.put(17, "DEVICE_CONTROL_ONE");
        controlCodeNames.put(18, "DEVICE_CONTROL_TWO");
        controlCodeNames.put(19, "DEVICE_CONTROL_THREE");
        controlCodeNames.put(20, "DEVICE_CONTROL_FOUR");
        controlCodeNames.put(21, "NEGATIVE_ACKNOWLEDGE");
        controlCodeNames.put(22, "SYNCHRONOUS_IDLE");
        controlCodeNames.put(23, "END_OF_TRANSMISSION_BLOCK");
        controlCodeNames.put(24, "CANCEL");
        controlCodeNames.put(25, "END_OF_MEDIUM");
        controlCodeNames.put(26, "SUBSTITUTE");
        controlCodeNames.put(27, "ESCAPE");
        controlCodeNames.put(28, "INFORMATION_SEPARATOR_FOUR");
        controlCodeNames.put(29, "INFORMATION_SEPARATOR_THREE");
        controlCodeNames.put(30, "INFORMATION_SEPARATOR_TWO");
        controlCodeNames.put(31, "INFORMATION_SEPARATOR_ONE");
        controlCodeNames.put(127, "DELETE");
        controlCodeNames.put(128, "CONTROL-0080");
        controlCodeNames.put(129, "CONTROL-0081");
        controlCodeNames.put(130, "BREAK_PERMITTED_HERE");
        controlCodeNames.put(131, "NO_BREAK_HERE");
        controlCodeNames.put(132, "CONTROL-0084");
        controlCodeNames.put(133, "NEXT_LINE");
        controlCodeNames.put(134, "START_OF_SELECTED_AREA");
        controlCodeNames.put(135, "END_OF_SELECTED_AREA");
        controlCodeNames.put(136, "CHARACTER_TABULATION_SET");
        controlCodeNames.put(137, "CHARACTER_TABULATION_WITH_JUSTIFICATION");
        controlCodeNames.put(138, "LINE_TABULATION_SET");
        controlCodeNames.put(139, "PARTIAL_LINE_FORWARD");
        controlCodeNames.put(140, "PARTIAL_LINE_BACKWARD");
        controlCodeNames.put(141, "REVERSE_LINE_FEED");
        controlCodeNames.put(142, "SINGLE_SHIFT_TWO");
        controlCodeNames.put(143, "SINGLE_SHIFT_THREE");
        controlCodeNames.put(144, "DEVICE_CONTROL_STRING");
        controlCodeNames.put(145, "PRIVATE_USE_ONE");
        controlCodeNames.put(146, "PRIVATE_USE_TWO");
        controlCodeNames.put(147, "SET_TRANSMIT_STATE");
        controlCodeNames.put(148, "CANCEL_CHARACTER");
        controlCodeNames.put(149, "MESSAGE_WAITING");
        controlCodeNames.put(150, "START_OF_GUARDED_AREA");
        controlCodeNames.put(151, "END_OF_GUARDED_AREA");
        controlCodeNames.put(152, "START_OF_STRING");
        controlCodeNames.put(153, "CONTROL-0099");
        controlCodeNames.put(154, "SINGLE_CHARACTER_INTRODUCER");
        controlCodeNames.put(155, "CONTROL_SEQUENCE_INTRODUCER");
        controlCodeNames.put(156, "STRING_TERMINATOR");
        controlCodeNames.put(157, "OPERATING_SYSTEM_COMMAND");
        controlCodeNames.put(158, "PRIVACY_MESSAGE");
        controlCodeNames.put(159, "APPLICATION_PROGRAM_COMMAND");
    }

    public static void setRepertoire(UnicodeSet rep) {
        repertoire = rep;
    }

    public static void setCharFallback(CLDRFile fallbk) {
        char_fallbk = fallbk;
    }

    public static String POSIXContraction(String s2) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            result.append(POSIXUtilities.POSIXCharName(cp));
        }
        return result.toString().replaceAll("><", "-");
    }

    public static String POSIXCharName(String s2) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            result.append(POSIXUtilities.POSIXCharName(cp));
        }
        return result.toString();
    }

    public static String POSIXCharName(int cp) {
        String n;
        StringBuffer result = new StringBuffer();
        result.append("<");
        if (cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122) {
            result.append((char)cp);
        } else if (cp >= 48 && cp <= 57) {
            n = UCharacter.getExtendedName(cp);
            result.append(n.replaceAll(" ", "_").replaceAll("DIGIT_", "").toLowerCase());
        } else if (cp >= 0 && cp <= 31 || cp >= 127 && cp <= 159) {
            if (controlCodeNames.isEmpty()) {
                POSIXUtilities.initControlCodeNames();
            }
            result.append(controlCodeNames.get(cp));
        } else if (cp == 32) {
            result.append("space");
        } else {
            n = UCharacter.getExtendedName(cp);
            result.append(n.replaceAll(" ", "_").replaceAll("<", "").replaceAll(">", "").toUpperCase());
        }
        int i = result.indexOf("_(");
        if (i >= 0) {
            result.setLength(i);
        }
        result.append(">");
        if (!repertoire.contains(cp)) {
            System.out.println("WARNING: character " + result.toString() + " is not in the target codeset.");
            String substituteString = "";
            boolean SubFound = false;
            String SearchLocation = "//supplementalData/characters/character-fallback/character[@value=\"" + UCharacter.toString(cp) + "\"]/substitute";
            Iterator<String> it = char_fallbk.iterator(SearchLocation, char_fallbk.getComparator());
            while (it.hasNext() && !SubFound) {
                String path = it.next();
                substituteString = char_fallbk.getStringValue(path);
                if (!repertoire.containsAll(substituteString)) continue;
                SubFound = true;
            }
            if (SubFound) {
                System.out.println("\tSubstituted: " + POSIXUtilities.POSIXCharName(substituteString));
                result = new StringBuffer(POSIXUtilities.POSIXCharName(substituteString));
            } else {
                System.out.println("\tNo acceptable substitute found. The resulting locale source may not compile.");
            }
        }
        return result.toString();
    }

    public static String POSIXCharFullName(String s2) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            result.append(POSIXUtilities.POSIXCharFullName(cp));
        }
        return result.toString();
    }

    public static String POSIXCharFullName(int cp) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        String n = UCharacter.getExtendedName(cp);
        result.append(n.replaceAll(" ", "_").replaceAll("<", "").replaceAll(">", "").toUpperCase());
        int i = result.indexOf("_(");
        if (i >= 0) {
            result.setLength(i);
        }
        result.append(">");
        return result.toString();
    }

    public static String POSIXCharNameNP(String s2) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            if (cp <= 127) {
                result.append((char)cp);
                continue;
            }
            result.append(POSIXUtilities.POSIXCharName(cp));
        }
        return result.toString();
    }

    public static String POSIXDateTimeFormat(String s2, boolean UseAltDigits, POSIXVariant variant) {
        String[][] FieldDescriptors = new String[][]{{"/d/", "<SOLIDUS>%d<SOLIDUS>", "<SOLIDUS>%d<SOLIDUS>", "<SOLIDUS>%d<SOLIDUS>"}, {"/", "<SOLIDUS>", "<SOLIDUS>", "<SOLIDUS>"}, {"DDD", "%j", "%j", "%j"}, {"EEEE", "%A", "%A", "%A"}, {"EEE", "%a", "%a", "%a"}, {"G", "%N", "%N", "%N"}, {"HH", "%H", "%OH", "%H"}, {"H", "%H", "%OH", "%k"}, {"KK", "%I", "%OI", "%I"}, {"K", "%I", "%OI", "%l"}, {"MMMM", "%B", "%B", "%B"}, {"MMM", "%b", "%b", "%b"}, {"MM", "%m", "%Om", "%m"}, {"M", "%m", "%Om", "%m"}, {"VVVV", "%Z", "%Z", "%Z"}, {"V", "%Z", "%Z", "%Z"}, {"a", "%p", "%p", "%p"}, {"dd", "%d", "%Od", "%d"}, {"d", "%e", "%Oe", "%e"}, {"hh", "%I", "%OI", "%I"}, {"h", "%I", "%OI", "%l"}, {"kk", "%H", "%OH", "%H"}, {"k", "%H", "%OH", "%k"}, {"mm", "%M", "%OM", "%M"}, {"m", "%M", "%OM", "%M"}, {"vvvv", "%Z", "%Z", "%Z"}, {"v", "%Z", "%Z", "%Z"}, {"yyyy", "%Y", "%Oy", "%Y"}, {"yy", "%y", "%Oy", "%y"}, {"y", "%Y", "%Oy", "%Y"}, {"zzzz", "%Z", "%Z", "%Z"}, {"zzz", "%Z", "%Z", "%Z"}, {"zz", "%Z", "%Z", "%Z"}, {"z", "%Z", "%Z", "%Z"}, {"ss", "%S", "%OS", "%S"}, {"s", "%S", "%OS", "%S"}};
        boolean inquotes = false;
        StringBuffer result = new StringBuffer("");
        int pos = 0;
        while (pos < s2.length()) {
            boolean replaced = false;
            for (int i = 0; i < FieldDescriptors.length && !replaced && !inquotes; ++i) {
                if (s2.indexOf(FieldDescriptors[i][0], pos) != pos) continue;
                if (UseAltDigits) {
                    result.append(FieldDescriptors[i][2]);
                } else if (variant.platform.equals("solaris")) {
                    result.append(FieldDescriptors[i][3]);
                } else {
                    result.append(FieldDescriptors[i][1]);
                }
                replaced = true;
                pos += FieldDescriptors[i][0].length();
            }
            if (replaced) continue;
            if (s2.charAt(pos) == '\'') {
                if (pos < s2.length() - 1 && s2.charAt(pos + 1) == '\'') {
                    result.append('\'');
                    ++pos;
                } else {
                    inquotes = !inquotes;
                }
            } else {
                result.append(s2.charAt(pos));
            }
            ++pos;
        }
        return result.toString();
    }

    public static String POSIXGrouping(String grouping_pattern) {
        String result;
        int i = grouping_pattern.indexOf(".");
        boolean first_grouping = true;
        if (i < 0) {
            result = "-1";
        } else {
            int j;
            result = new String();
            while ((j = grouping_pattern.lastIndexOf(",", i - 1)) > 0) {
                if (!first_grouping) {
                    result = result.concat(";");
                }
                Integer num_digits = i - j - 1;
                result = result.concat(num_digits.toString());
                first_grouping = false;
                i = j;
            }
        }
        if (result.length() == 0) {
            result = "-1";
        }
        return result;
    }

    public static boolean isBetween(int a, int b, int c) {
        return a < b && b < c || c < b && b < a;
    }

    public static String POSIXYesNoExpr(String s2) {
        StringBuffer result = new StringBuffer();
        String[] YesNoElements = s2.split(":");
        for (int i = 0; i < YesNoElements.length; ++i) {
            String cur = YesNoElements[i];
            if (cur.length() < 1 || !cur.toLowerCase().equals(cur)) continue;
            if (result.length() > 0) {
                result.append(")|(");
            } else {
                result.append("^((");
            }
            StringCharacterIterator si = new StringCharacterIterator(cur);
            boolean OptLastChars = false;
            char c = si.first();
            while (c != '\uffff') {
                if (c != Character.toUpperCase(c)) {
                    if (si.getIndex() == 1) {
                        result.append("(");
                        OptLastChars = true;
                    }
                    result.append("[");
                    result.append(c);
                    result.append(Character.toUpperCase(c));
                    result.append("]");
                } else {
                    result.append(c);
                }
                c = si.next();
            }
            if (!OptLastChars) continue;
            result.append(")?");
        }
        result.append("))");
        return POSIXUtilities.POSIXCharNameNP(result.toString());
    }

    static {
        controlCodeNames = new HashMap<Integer, String>();
    }
}

