/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.XPathParts;

public class CheckMetazones
extends CheckCLDR {
    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (value == null) {
            return this;
        }
        if (path.indexOf("/metazone") < 0) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        if (value.matches(".*\\p{Nd}.*")) {
            if (!this.getCldrFileToCheck().getSourceLocaleID(path, null).equals(this.getCldrFileToCheck().getLocaleID())) {
                return this;
            }
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.metazoneContainsDigit).setMessage("Metazone name contains digits - translate only the name"));
        }
        if (CheckMetazones.isDSTPathForNonDSTMetazone(path)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.extraMetazoneString).setMessage("Extra metazone string - should only contain standard value for a non-DST metazone"));
        }
        return this;
    }

    public static boolean isDSTPathForNonDSTMetazone(String path) {
        XPathParts parts;
        String metazoneName;
        return (path.indexOf("/long") >= 0 || path.indexOf("/short") >= 0) && !CheckMetazones.metazoneUsesDST(metazoneName = (parts = XPathParts.getFrozenInstance(path)).getAttributeValue(3, "type")) && path.indexOf("/standard") < 0;
    }

    public static boolean metazoneUsesDST(String name) {
        return LogicalGrouping.metazonesDSTSet.contains(name);
    }
}

