/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.util.TimeZone;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.XPathParts;

public class CheckZones
extends FactoryCheckCLDR {
    private TimezoneFormatter timezoneFormatter;
    String previousZone = new String();
    String previousFrom = new String("1970-01-01");
    String previousTo = new String("present");

    public CheckZones(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFile, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFile == null) {
            return this;
        }
        super.handleSetCldrFileToCheck(cldrFile, options, possibleErrors);
        try {
            this.timezoneFormatter = new TimezoneFormatter(this.getResolvedCldrFileToCheck());
        }
        catch (RuntimeException e) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.cannotCreateZoneFormatter).setMessage("Checking zones: " + e.getMessage()));
        }
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (path.indexOf("timeZoneNames") < 0 || path.indexOf("usesMetazone") < 0) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        if (this.timezoneFormatter == null) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        String zone = parts.getAttributeValue(3, "type");
        String from = parts.containsAttribute("from") ? parts.getAttributeValue(4, "from") : "1970-01-01";
        String to = parts.containsAttribute("to") ? parts.getAttributeValue(4, "to") : "present";
        if (zone.equals(this.previousZone)) {
            if (from.compareTo(this.previousTo) < 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.multipleMetazoneMappings).setMessage("Multiple metazone mappings between {1} and {0}", this.previousTo, from));
            }
            if (from.compareTo(this.previousTo) > 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.noMetazoneMapping).setMessage("No metazone mapping between {0} and {1}", this.previousTo, from));
            }
        } else {
            if (this.previousFrom.compareTo("1970-01-01") != 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.noMetazoneMappingAfter1970).setMessage("Zone {0} has no metazone mapping between 1970-01-01 and {1}", this.previousZone, this.previousFrom));
            }
            if (this.previousTo.compareTo("present") != 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.noMetazoneMappingBeforeNow).setMessage("Zone {0} has no metazone mapping between {1} and present.", this.previousZone, this.previousTo));
            }
            this.previousFrom = from;
        }
        this.previousTo = to;
        this.previousZone = zone;
        return this;
    }

    public static String exampleTextForXpath(TimezoneFormatter timezoneFormatter, String path) {
        XPathParts parts = XPathParts.getFrozenInstance(path);
        if (parts.containsElement("zone")) {
            String id = parts.getAttributeValue(3, "type");
            TimeZone tz = TimeZone.getTimeZone(id);
            String pat = "vvvv";
            if (parts.containsElement("exemplarCity")) {
                int delim = id.indexOf(47);
                if (delim >= 0) {
                    String formatted = id.substring(delim + 1).replaceAll("_", " ");
                    return formatted;
                }
            } else if (!parts.containsElement("usesMetazone")) {
                if (parts.containsElement("generic")) {
                    pat = "vvvv";
                    if (parts.containsElement("short")) {
                        pat = "v";
                    }
                } else {
                    pat = "zzzz";
                    if (parts.containsElement("short")) {
                        pat = "z";
                    }
                }
                boolean daylight = parts.containsElement("daylight");
                int offset = tz.getRawOffset();
                if (daylight) {
                    offset += tz.getDSTSavings();
                }
                String formatted = timezoneFormatter.getFormattedZone(id, pat, daylight, offset, true);
                return formatted;
            }
        }
        return null;
    }

    public CheckCLDR handleGetExamples(String path, String fullPath, String value, CheckCLDR.Options options, List result) {
        if (path.indexOf("timeZoneNames") < 0) {
            return this;
        }
        if (this.timezoneFormatter == null) {
            throw new InternalCldrException("This should not occur: setCldrFileToCheck must create a TimezoneFormatter.");
        }
        String formatted = CheckZones.exampleTextForXpath(this.timezoneFormatter, path);
        if (formatted != null) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.exampleType).setMessage("Formatted value (if removed): \"{0}\"", formatted));
        }
        return this;
    }
}

