/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.TreeSet;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.TestCache;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;

@Deprecated
public class ChartSupplemental
extends Chart {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    static final CLDRFile ENGLISH = CLDR_CONFIG.getEnglish();
    static final String DIR = CLDRPaths.CHART_DIRECTORY + "verify/supplemental/";
    private final String locale;

    public ChartSupplemental(String locale) {
        this.locale = locale;
    }

    @Override
    public String getDirectory() {
        return DIR;
    }

    @Override
    public String getTitle() {
        return ENGLISH.nameGetter().getNameFromIdentifier(this.locale) + ": Overall Errors";
    }

    @Override
    public String getExplanation() {
        return "<p>This chart shows errors which apply to the entire locale.</p>";
    }

    @Override
    public String getFileName() {
        return this.locale;
    }

    @Override
    public void writeContents(Writer pw, Factory factory, TestCache.TestResultBundle test, CheckCLDR.SubtypeToURLProvider urlProvider) throws IOException {
        CLDRFile cldrFile = factory.make(this.locale, true);
        if (test != null) {
            TreeSet<CheckCLDR.CheckStatus> pp = new TreeSet<CheckCLDR.CheckStatus>();
            pp.addAll(test.getPossibleProblems());
            for (String x : cldrFile) {
                ArrayList<CheckCLDR.CheckStatus> result = new ArrayList<CheckCLDR.CheckStatus>();
                test.check(x, result, cldrFile.getStringValue(x));
                for (CheckCLDR.CheckStatus s2 : result) {
                    if (!s2.getEntireLocale()) continue;
                    pp.add(s2);
                }
            }
            if (pp.isEmpty()) {
                pw.write("<h3>No Errors</h3>\n");
                pw.write("There are no overall locale issues to report");
            } else {
                pw.write("<h3>Overall Errors</h3>\n");
                pw.write("<ol>\n");
                for (CheckCLDR.CheckStatus s3 : pp) {
                    pw.write(String.format("<li> <b>%s</b> <i title='%s'>%s</i>\n", new Object[]{s3.getType(), s3.getSubtype().name(), s3.getSubtype()}));
                    pw.write("<p>" + s3.getMessage() + "</p>");
                    if (urlProvider != null) {
                        String moreDetailsUrl = (String)urlProvider.apply(s3.getSubtype());
                        pw.write(String.format("<a href=\"%s\">more details</a>", moreDetailsUrl));
                    }
                    pw.write("</li>\n");
                }
                pw.write("</ol>\n\n");
            }
        }
        pw.write("</div> <!-- ReportSupplemental -->\n");
    }
}

