/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.XPathParts;

public class GenerateNumberingSystemAliases {
    public static void main(String[] args) throws Exception {
        Map<Pair<String, String>, String> missing = GenerateNumberingSystemAliases.getMissingRootNumberingSystems();
        if (missing.isEmpty()) {
            System.out.println("Nothing to do, all OK.");
            return;
        }
        String dir = CLDRPaths.MAIN_DIRECTORY;
        String fileName = "root.xml";
        System.out.println("Starting update of " + dir + "root.xml");
        CLDRConfig config = CLDRConfig.getInstance();
        CLDRFile root = config.getCLDRFile("root", false).cloneAsThawed();
        XPathParts xpp = XPathParts.getFrozenInstance("//ldml/numbers/_____/alias").cloneAsThawed().setAttribute(-1, "source", "locale");
        System.out.println(MessageFormat.format("Updating {0, plural, one {# alias} other {# aliases}} under //ldml/numbers in {1}", missing.size(), "root.xml"));
        for (Map.Entry<Pair<String, String>, String> e : missing.entrySet()) {
            String ns = e.getKey().getFirst();
            String element = e.getKey().getSecond();
            String path = e.getValue();
            xpp.setElement(-2, element).setAttribute(-2, "numberSystem", ns).setAttribute(-1, "path", "../" + element + "[@numberSystem='latn']");
            root.add(xpp.toString(), "");
        }
        try (TempPrintWriter out = TempPrintWriter.openUTF8Writer(dir, "root.xml");){
            root.write(out.asPrintWriter());
        }
        System.out.println("Done. Don't forget to commit " + dir + "root.xml");
    }

    public static Map<Pair<String, String>, String> getMissingRootNumberingSystems() {
        CLDRConfig config = CLDRConfig.getInstance();
        CLDRFile root = config.getRoot();
        ImmutableSet<String> expectedElement = ImmutableSet.of("symbols", "currencyFormats", "decimalFormats", "miscPatterns", "percentFormats", "scientificFormats", new String[0]);
        XPathParts xpp = XPathParts.getFrozenInstance("//ldml/numbers/______").cloneAsThawed();
        TreeMap<Pair<String, String>, String> missing = new TreeMap<Pair<String, String>, String>();
        for (String ns : config.getSupplementalDataInfo().getNumericNumberingSystems()) {
            for (String element : expectedElement) {
                xpp.setElement(-1, element);
                xpp.setAttribute(-1, "numberSystem", ns);
                String basePath = xpp.toString();
                if (root.iterator(basePath).hasNext()) continue;
                missing.put(Pair.of(ns, element), basePath);
            }
        }
        return missing;
    }
}

