/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.text.DateIntervalInfo;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.util.ULocale;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class ShowInconsistentAvailable {
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    static boolean INCLUDE_ERA = true;
    static boolean SHOW_PROGRESS_RAW = false;
    static boolean SHOW_PROGRESS = false;
    static String DEBUG_ONLY_CALENDAR = null;
    static SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();
    private static final Joiner TAB_JOINER = Joiner.on('\t');
    private static final Joiner LF_JOINER = Joiner.on('\n');
    static DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
    static Factory f = CONFIG.getCldrFactory();
    static PathHeader.Factory phf = PathHeader.getFactory();
    static int counter = 0;
    static Set<String> nullErrors = new LinkedHashSet<String>();
    private static final VariableField2 VARIABLE_FIELD_U = new VariableField2((Object)"U", true);

    public static void main(String[] args) {
        MyOptions.parse(args);
        Set<String> cldrLocales = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr);
        Set<String> specialLocales = StandardCodes.make().getLocaleCoverageLocales(Organization.special);
        Sets.SetView<String> cldrLocalesWithoutSpecial = Sets.difference(cldrLocales, specialLocales);
        if (MyOptions.ordering.option.doesOccur()) {
            ShowInconsistentAvailable.showOrdering(cldrLocalesWithoutSpecial);
        }
        if (MyOptions.root.option.doesOccur()) {
            ShowInconsistentAvailable.getRootPaths();
        }
        if (MyOptions.inconsistencies.option.doesOccur()) {
            ShowInconsistentAvailable.showInconsistencies(cldrLocalesWithoutSpecial);
        }
    }

    public static void showInconsistencies(Set<String> cldrLocalesWithoutSpecial) {
        System.out.println("counter, locale, fLocale, calendar, skeleton, alt, coverage, value, sSimple, vSimple, error".replace(", ", "\t"));
        ShowInconsistentAvailable.showInconsistenciesInLocale("root");
        for (String locale : cldrLocalesWithoutSpecial) {
            ShowInconsistentAvailable.showInconsistenciesInLocale(locale);
        }
        nullErrors = ImmutableSet.copyOf(nullErrors.stream().map(x -> ++counter + "\t" + x).collect(Collectors.toList()));
        System.out.println(Joiner.on('\n').join(nullErrors));
    }

    public static void showOrdering(Set<String> cldrLocalesWithoutSpecial) {
        TreeMultimap<String, SimplePattern> calendarToSPatterns = TreeMultimap.create();
        for (String locale : cldrLocalesWithoutSpecial) {
            ShowInconsistentAvailable.getTCPaths(locale, calendarToSPatterns);
        }
        AbstractCollection ts = new TreeSet();
        ts.addAll(calendarToSPatterns.values());
        ts = ImmutableSet.copyOf(ts);
        TreeSet<VariableField2> fields = new TreeSet<VariableField2>();
        for (SimplePattern xx : ts) {
            fields.addAll(xx.internal);
        }
        fields.remove(VARIABLE_FIELD_U);
        for (VariableField2 field : fields) {
            System.out.print("\n\u220bVar\tCal");
            for (SimplePattern p : ts) {
                if (!p.internal.contains(field)) continue;
                System.out.print("\t" + String.valueOf(p));
            }
            System.out.println();
            for (String cal : calendarToSPatterns.keySet()) {
                System.out.print(SimplePattern.pretty(field) + "\t" + cal);
                for (SimplePattern p : ts) {
                    if (!p.internal.contains(field)) continue;
                    System.out.print("\t" + (calendarToSPatterns.containsEntry(cal, p) ? "Y" : "-"));
                }
                System.out.println();
            }
        }
    }

    private static void getTCPaths(String locale, Multimap<String, SimplePattern> calendarToSPatterns) {
        CLDRFile cldrFile = f.make(locale, false);
        DateIntervalInfo fInfo = new DateIntervalInfo(new ULocale(locale)).freeze();
        for (String path : cldrFile) {
            String lastElement;
            String value = cldrFile.getStringValue(path);
            if (value == null || value.isBlank() || value.equals("\u2191\u2191\u2191")) continue;
            XPathParts parts = XPathParts.getFrozenInstance(path);
            switch (lastElement = parts.getElement(-1)) {
                case "dateFormatItem": {
                    String calendar = parts.getAttributeValue(3, "type");
                    SimplePattern valueSimplePattern = new SimplePattern(value, PatternType.pattern);
                    calendarToSPatterns.put(calendar, valueSimplePattern);
                    break;
                }
                case "greatestDifference": {
                    String calendar = parts.getAttributeValue(3, "type");
                    SimplePattern first = null;
                    SimplePattern second = null;
                    DateIntervalInfo.PatternInfo pattern = DateIntervalInfo.genPatternInfo(value, false);
                    try {
                        first = new SimplePattern(pattern.getFirstPart(), PatternType.pattern);
                        second = new SimplePattern(pattern.getSecondPart(), PatternType.pattern);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (first == null || second == null) {
                        String skeleton = parts.getAttributeValue(-2, "id");
                        String greatest = parts.getAttributeValue(-1, "id");
                        System.out.println(TAB_JOINER.join("Error:", locale, calendar, lastElement, skeleton, greatest, value));
                        break;
                    }
                    calendarToSPatterns.put(calendar, first);
                    calendarToSPatterns.put(calendar, second);
                }
            }
        }
    }

    private static void getRootPaths() {
        TreeMultimap<String, String> skelToCals = TreeMultimap.create();
        HashMap<Pair<String, String>, String> skelCalToSource = new HashMap<Pair<String, String>, String>();
        TreeSet<String> calendars = new TreeSet<String>();
        CLDRFile root = CONFIG.getRoot();
        for (String string : root) {
            XPathParts parts = XPathParts.getFrozenInstance(string);
            if (!parts.getElement(-1).equals("dateFormatItem")) continue;
            String calendar = parts.getAttributeValue(3, "type");
            calendars.add(calendar);
            String skeleton = parts.getAttributeValue(-1, "id");
            String alt = parts.getAttributeValue(-1, "alt");
            if (alt != null) {
                throw new IllegalArgumentException("unexpected");
            }
            skelToCals.put(skeleton, calendar);
            CLDRFile.Status out = new CLDRFile.Status();
            root.getSourceLocaleID(string, out);
            String source = "none";
            if (out.pathWhereFound != null) {
                XPathParts parts2 = XPathParts.getFrozenInstance(out.pathWhereFound);
                source = parts2.getAttributeValue(3, "type");
            }
            skelCalToSource.put(Pair.of(skeleton, calendar), source);
        }
        System.out.println("skeleton\t" + Joiner.on('\t').join(calendars));
        for (Map.Entry entry : skelToCals.asMap().entrySet()) {
            String skeleton = (String)entry.getKey();
            System.out.print(skeleton);
            Collection currentCalendars = (Collection)entry.getValue();
            for (String calendar : calendars) {
                String source = (String)skelCalToSource.get(Pair.of(skeleton, calendar));
                System.out.print("\t" + (currentCalendars.contains(calendar) ? source : "n/a"));
            }
            System.out.println();
        }
        System.out.println();
    }

    /*
     * WARNING - void declaration
     */
    static void showInconsistenciesInLocale(String locale) {
        CLDRFile cldrFile = f.make(locale, true);
        CLDRFile.Status out = new CLDRFile.Status();
        TreeMultimap<String, PathHeader> sorted = TreeMultimap.create();
        for (String string : cldrFile) {
            XPathParts parts = XPathParts.getFrozenInstance(string);
            if (!parts.getElement(-1).equals("dateFormatItem")) continue;
            String calendar = parts.getAttributeValue(3, "type");
            if (DEBUG_ONLY_CALENDAR != null && !calendar.equals(DEBUG_ONLY_CALENDAR)) continue;
            if (SHOW_PROGRESS_RAW) {
                void var10_12;
                String value = cldrFile.getStringValue(string);
                String skeleton = parts.getAttributeValue(-1, "id");
                String string2 = parts.getAttributeValue(-1, "alt");
                if (string2 == null) {
                    String string3 = "";
                }
                SimplePattern skeletonSimplePattern = new SimplePattern(skeleton, PatternType.skeleton);
                SimplePattern valueSimplePattern = new SimplePattern(value, PatternType.pattern);
                String fLocale = cldrFile.getSourceLocaleID(string, out);
                String fPath = out.pathWhereFound;
                System.out.println(TAB_JOINER.join(List.of("" + ++counter, locale, fLocale, calendar, skeleton, var10_12, value, skeletonSimplePattern, valueSimplePattern)));
            }
            sorted.put(calendar, phf.fromPath(string));
        }
        for (Map.Entry entry : sorted.asMap().entrySet()) {
            String calendar = (String)entry.getKey();
            Collection phset = (Collection)entry.getValue();
            TreeMap<SimplePattern, LinkedHashMultimap<SimplePattern, PatternData2>> skelSP2valSP2Data = new TreeMap<SimplePattern, LinkedHashMultimap<SimplePattern, PatternData2>>();
            for (PathHeader pathHeader : phset) {
                String path = pathHeader.getOriginalPath();
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String value = cldrFile.getStringValue(path);
                if (value == null) {
                    nullErrors.add(locale + "\t" + path);
                    continue;
                }
                String fLocale = cldrFile.getSourceLocaleID(path, out);
                String pathWhereFound = out.pathWhereFound;
                String skeleton = parts.getAttributeValue(-1, "id");
                String alt = parts.getAttributeValue(-1, "alt");
                if (alt == null) {
                    alt = "";
                }
                if (alt.equals("variant")) continue;
                SimplePattern skeletonSimplePattern = new SimplePattern(skeleton, PatternType.skeleton);
                SimplePattern valueSimplePattern = new SimplePattern(value, PatternType.pattern);
                LinkedHashMultimap<SimplePattern, PatternData2> valueMM = (LinkedHashMultimap<SimplePattern, PatternData2>)skelSP2valSP2Data.get(skeletonSimplePattern);
                if (valueMM == null) {
                    valueMM = LinkedHashMultimap.create();
                    skelSP2valSP2Data.put(skeletonSimplePattern, valueMM);
                }
                valueMM.put(valueSimplePattern, new PatternData2(locale, fLocale, calendar, skeleton, alt, SDI.getCoverageLevel(path, locale).toString(), value));
            }
            for (Map.Entry entry2 : skelSP2valSP2Data.entrySet()) {
                boolean inconsistentValues;
                SimplePattern skeletonSP = (SimplePattern)entry2.getKey();
                Set valueSet = ((Multimap)entry2.getValue()).keySet();
                boolean bl = inconsistentValues = valueSet.size() > 1;
                if (inconsistentValues) {
                    TreeSet<String> neuteredMonths = new TreeSet<String>();
                    for (SimplePattern p : valueSet) {
                        neuteredMonths.add(p.toString().replace("M\u207f", "M\u02e2"));
                    }
                    if (neuteredMonths.size() == 1) {
                        inconsistentValues = false;
                    }
                }
                for (Map.Entry entry22 : ((Multimap)entry2.getValue()).asMap().entrySet()) {
                    SimplePattern valueSP = (SimplePattern)entry22.getKey();
                    if (!SHOW_PROGRESS && !inconsistentValues) continue;
                    for (PatternData2 patternData : entry22.getValue()) {
                        System.out.println(++counter + "\t" + String.valueOf(patternData) + "\t" + String.valueOf(skeletonSP) + "\t" + String.valueOf(valueSP) + (inconsistentValues ? "\t\u274c" : ""));
                    }
                }
                if (!inconsistentValues) continue;
                System.out.println();
            }
        }
    }

    static class SimplePattern
    implements Comparable<SimplePattern> {
        static Comparator<Iterable<VariableField2>> comp = Comparators.lexicographical(Comparator.naturalOrder());
        Collection<VariableField2> internal;

        SimplePattern(String id, PatternType patternType) {
            this.internal = patternType == PatternType.skeleton ? new TreeSet() : new LinkedHashSet();
            block5: for (Object item : fp.set(id).getItems()) {
                if (!(item instanceof DateTimePatternGenerator.VariableField)) continue;
                VariableField2 v = new VariableField2(item, true);
                switch (v.getType()) {
                    case 0: {
                        if (INCLUDE_ERA || patternType != PatternType.pattern) break;
                        continue block5;
                    }
                    case 10: {
                        continue block5;
                    }
                    case 1: {
                        v = VARIABLE_FIELD_U;
                    }
                }
                this.internal.add(v);
            }
            if (patternType == PatternType.pattern) {
                this.internal = List.copyOf(this.internal);
            }
        }

        public String toString() {
            return this.internal.stream().map(v -> SimplePattern.pretty(v)).collect(Collectors.joining(""));
        }

        public static String pretty(VariableField2 v) {
            return DateTimePatternGenerator.VariableField.getCanonicalCode(v.getType()) + (v.isNumeric() ? "\u207f" : "\u02e2");
        }

        @Override
        public int compareTo(SimplePattern o) {
            return comp.compare(this.internal, o.internal);
        }

        public boolean equals(Object obj) {
            return this.internal.equals(((SimplePattern)obj).internal);
        }

        public int hashCode() {
            return this.internal.hashCode();
        }
    }

    public static enum PatternType {
        skeleton,
        pattern;

    }

    static class VariableField2
    extends DateTimePatternGenerator.VariableField
    implements Comparable<VariableField2> {
        public VariableField2(Object vf, boolean strict) {
            super(vf.toString(), strict);
        }

        @Override
        public int compareTo(VariableField2 o) {
            return ComparisonChain.start().compare(this.getType(), o.getType()).compare(this.isNumeric(), o.isNumeric()).result();
        }

        public boolean equals(Object obj) {
            return this.compareTo((VariableField2)obj) == 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.getType(), this.isNumeric());
        }
    }

    static class PatternData2 {
        List<String> data;

        PatternData2(String ... strings) {
            this.data = Arrays.asList(strings);
        }

        public String toString() {
            return TAB_JOINER.join(this.data);
        }

        public boolean equals(Object obj) {
            return this.data.equals(((PatternData2)obj).data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }

    private static enum MyOptions {
        ordering(new Option.Params().setHelp("find the ordering of fields in availableFormats and intervals")),
        inconsistencies(new Option.Params().setHelp("find inconsistancies in available formatts")),
        root(new Option.Params().setHelp("find root paths"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

