/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool.resolver;

import java.util.HashSet;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;

public class ResolverUtils {
    static int verbosity = 2;

    private ResolverUtils() {
    }

    public static Set<String> getAllPaths(CLDRFile file) {
        String locale = file.getLocaleID();
        HashSet<String> paths = new HashSet<String>();
        for (String path : file) {
            paths.add(path);
        }
        for (String path : file.getExtraPaths()) {
            if (file.getStringValue(path) != null) {
                paths.add(path);
                continue;
            }
            ResolverUtils.debugPrintln(path + " is null in " + locale + ".", 3);
        }
        return paths;
    }

    public static String strRep(String str) {
        if (str == null) {
            return "[null]";
        }
        if (str.isEmpty()) {
            return "[empty]";
        }
        return str;
    }

    static void debugPrint(String str, int msgVerbosity) {
        if (verbosity >= msgVerbosity) {
            System.out.print(str);
        }
    }

    static void debugPrintln(String str, int msgVerbosity) {
        ResolverUtils.debugPrint(str + "\n", msgVerbosity);
    }
}

