/*
 * Decompiled with CFR 0.152.
 */
package com.google.myanmartools;

import com.google.myanmartools.Phase;
import java.util.ArrayList;

public abstract class Transliterate {
    private final ArrayList<Phase> translitPhases = new ArrayList();
    private final String name;
    private boolean debugMode;

    Transliterate(String id) {
        this.name = id;
    }

    Phase addPhase() {
        Phase newPhase = new Phase();
        newPhase.setInfo(" " + this.translitPhases.size());
        this.translitPhases.add(newPhase);
        newPhase.setDebugMode(this.debugMode);
        return newPhase;
    }

    void setDebugMode(boolean newMode) {
        this.debugMode = newMode;
        for (Phase phase : this.translitPhases) {
            phase.setDebugMode(this.debugMode);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transliterator name = ").append(this.name).append("\n");
        sb.append("  Phase count: ").append(this.translitPhases.size()).append("\n");
        for (Phase p : this.translitPhases) {
            sb.append(p.printPhase());
        }
        return sb.toString();
    }

    public String convert(CharSequence inString) {
        return this.runAllPhases(inString.toString());
    }

    private String runAllPhases(String inString) {
        String outString = inString;
        for (Phase phase : this.translitPhases) {
            outString = phase.runPhase(phase, outString);
        }
        return outString;
    }
}

