/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.Timer;

public class NormalizedIdentifierParser {
    static final UnicodeSet XmlNameStartChar = new UnicodeSet("[\\: A-Z _ a-z \\u00C0-\\u00D6 \\u00D8-\\u00F6 \\u00F8-\\u02FF \\u0370-\\u037D \\u037F-\\u1FFF \\u200C-\\u200D\\u2070-\\u218F \\u2C00-\\u2FEF \\u3001-\\uD7FF \\uF900-\\uFDCF \\uFDF0-\\uFFFD \\U00010000-\\U000EFFFF]").freeze();
    static final UnicodeSet XmlNameContinueChar = new UnicodeSet("[- . 0-9 \\u00B7 \\u0300-\\u036F \\u203F-\\u2040]").freeze();
    static final UnicodeSet XmlNameChar = new UnicodeSet(XmlNameStartChar).addAll(XmlNameContinueChar).freeze();
    static final UnicodeSet XmlWhiteSpace = new UnicodeSet("[\\u0009\\u000D\\u000A\\u0020]").freeze();
    static final UnicodeSet XmlIllegal = new UnicodeSet("[^\\u0009\\u000D\\u000A\\u0020-\ud7ff\\uE000-\\uFFFD\\U00010000-\\U000EFFFF]").freeze();
    static final UnicodeSet NfcSafe = new UnicodeSet("[:nfkcqc=yes:]").freeze();
    private String input;
    private int endPosition;
    private int startPosition;
    private Status status;
    private boolean knownNfc;

    public NormalizedIdentifierParser set(String input, int position) {
        this.input = input;
        this.startPosition = this.endPosition = position;
        this.status = Status.UNKNOWN;
        return this;
    }

    public Status next() {
        this.startPosition = this.endPosition;
        if (this.endPosition >= this.input.length()) {
            this.status = Status.DONE;
            return this.status;
        }
        int codePoint = this.input.codePointAt(this.endPosition);
        CharType type = this.getCharType(codePoint);
        this.endPosition += codePoint < 65536 ? 1 : 2;
        switch (type) {
            case NameStartNFC: {
                this.knownNfc = true;
                this.status = Status.Name;
                break;
            }
            case NameStartOther: {
                this.knownNfc = false;
                this.status = Status.Name;
                break;
            }
            case NameContinueNFC: {
                this.knownNfc = true;
                this.status = Status.NameContinue;
                break;
            }
            case NameContinueOther: {
                this.knownNfc = false;
                this.status = Status.NameContinue;
                break;
            }
            default: {
                this.knownNfc = NfcSafe.contains(codePoint);
                return Status.NotNameChar;
            }
        }
        block10: while (this.endPosition < this.input.length()) {
            codePoint = this.input.codePointAt(this.endPosition);
            type = this.getCharType(codePoint);
            switch (type) {
                case NameStartOther: 
                case NameContinueOther: {
                    this.knownNfc = false;
                    break;
                }
                case NameStartNFC: 
                case NameContinueNFC: {
                    break;
                }
                default: {
                    break block10;
                }
            }
            this.endPosition += codePoint < 65536 ? 1 : 2;
        }
        return this.status;
    }

    public CharType getCharType(int codePoint) {
        if (XmlNameContinueChar.contains(codePoint)) {
            return NfcSafe.contains(codePoint) ? CharType.NameContinueNFC : CharType.NameContinueOther;
        }
        if (XmlNameStartChar.contains(codePoint)) {
            return NfcSafe.contains(codePoint) ? CharType.NameStartNFC : CharType.NameStartOther;
        }
        if (XmlIllegal.contains(codePoint)) {
            return CharType.Illegal;
        }
        if (XmlWhiteSpace.contains(codePoint)) {
            return CharType.Whitespace;
        }
        return CharType.Other;
    }

    public String getToken() {
        return this.input.substring(this.startPosition, this.endPosition);
    }

    public Status getStatus() {
        return this.status;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public boolean isKnownNfc() {
        return this.knownNfc;
    }

    Status getIdStatus(String s2) {
        this.set(s2, 0).next();
        if (this.endPosition != s2.length()) {
            return Status.NotNameChar;
        }
        return this.getStatus();
    }

    static void showDiffs() {
        TreeMap map = new TreeMap();
        NormalizedIdentifierParser parser = new NormalizedIdentifierParser();
        for (int codePoint = 0; codePoint <= 0x10FFFF; ++codePoint) {
            UnicodeSet set;
            String target;
            Status targetStatus;
            String source = new StringBuilder().appendCodePoint(codePoint).toString();
            Status sourceStatus = parser.getIdStatus(source);
            if (sourceStatus == (targetStatus = parser.getIdStatus(target = Normalizer.normalize(codePoint, Normalizer.NFC)))) continue;
            TreeMap<Status, UnicodeSet> map2 = (TreeMap<Status, UnicodeSet>)map.get((Object)sourceStatus);
            if (map2 == null) {
                map2 = new TreeMap<Status, UnicodeSet>();
                map.put(sourceStatus, map2);
            }
            if ((set = (UnicodeSet)map2.get((Object)targetStatus)) == null) {
                set = new UnicodeSet();
                map2.put(targetStatus, set);
            }
            set.add(codePoint);
        }
        for (Status sourceStatus : map.keySet()) {
            Map map2 = (Map)map.get((Object)sourceStatus);
            for (Status targetStatus : map2.keySet()) {
                UnicodeSet set = (UnicodeSet)map2.get((Object)targetStatus);
                System.out.println(String.valueOf((Object)sourceStatus) + "\t=>\t" + String.valueOf((Object)targetStatus) + "\t" + String.valueOf(set));
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("NameStart: " + String.valueOf(XmlNameStartChar));
        System.out.println("NameContinue: " + String.valueOf(XmlNameContinueChar));
        System.out.println("Whitespace: " + String.valueOf(XmlWhiteSpace));
        System.out.println("Illegal: " + String.valueOf(XmlIllegal));
        NormalizedIdentifierParser.compareNormalizer();
        NormalizedIdentifierParser parser = new NormalizedIdentifierParser();
        parser.set("\u0308ghi)j\u0308$abc+def*(", 0);
        Status status = parser.next();
        while (status != Status.DONE) {
            System.out.println(String.valueOf((Object)status) + ": \t" + parser.getToken() + (!parser.isKnownNfc() ? "\tNot Known NFC!" : ""));
            status = parser.next();
        }
    }

    private static void compareNormalizer() {
        int iterations = 100000000;
        NormalizedIdentifierParser.compareNormalizer("n\u00f6rmalization", 100000000);
        NormalizedIdentifierParser.compareNormalizer("No\u0308rmalization", 100000000);
    }

    private static void compareNormalizer(String test, int iterations) {
        String s2 = test.toLowerCase();
        s2 = Normalizer.normalize(test, Normalizer.NFC);
        Timer timer = new Timer();
        timer.start();
        for (int i = 0; i < iterations; ++i) {
            s2 = test.toLowerCase();
        }
        timer.stop();
        long lowercaseDuration = timer.getDuration();
        System.out.println("Java Lowercasing: " + (double)lowercaseDuration * 1000.0 / (double)iterations + "\u00b5s; for " + test);
        timer.start();
        for (int i = 0; i < iterations; ++i) {
            s2 = Normalizer.normalize(test, Normalizer.NFC);
        }
        timer.stop();
        long nfcDuration = timer.getDuration();
        System.out.println("ICU Normalizing: " + (double)nfcDuration * 1000.0 / (double)iterations + "\u00b5s = " + ((double)nfcDuration * 100.0 / (double)lowercaseDuration - 1.0) + "%; for " + test);
    }

    static enum CharType {
        Illegal,
        NameContinueNFC,
        NameContinueOther,
        NameStartNFC,
        NameStartOther,
        Whitespace,
        Other;

    }

    static enum Status {
        NotNameChar,
        NameContinue,
        Name,
        UNKNOWN,
        DONE;

    }
}

