/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu.dev.test;

import java.io.IOException;
import java.io.Writer;
import org.unicode.cldr.icu.dev.test.TestLog;

public final class TestLogWriter
extends Writer {
    private TestLog log;
    private int level;
    private boolean closed;

    public TestLogWriter(TestLog log, int level) {
        this.log = log;
        this.level = level;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(String str) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if ("\r\n".indexOf(str) != -1) {
            this.log.msg("", this.level, this.level == 2, true);
        } else {
            this.log.msg(str, this.level, this.level == 2, false);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

