/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class CheckAttributeValues
extends FactoryCheckCLDR {
    private static final Predicate<String> NOT_DONE_YET = new RegexMatcher().set(".*", 4);
    private static final boolean FIND_MISSING = CldrUtility.getProperty("FIND_MISSING_ATTRIBUTE_TESTS", false);
    private static final boolean SHOW_UNNECESSARY = false;
    static LinkedHashSet<String> elementOrder = new LinkedHashSet();
    static LinkedHashSet<String> attributeOrder = new LinkedHashSet();
    static LinkedHashSet<String> serialElements = new LinkedHashSet();
    static Map<String, Map<String, MatcherPattern>> element_attribute_validity = new HashMap<String, Map<String, MatcherPattern>>();
    static Map<String, MatcherPattern> common_attribute_validity = new HashMap<String, MatcherPattern>();
    static Map<String, MatcherPattern> variables = new HashMap<String, MatcherPattern>();
    static boolean initialized = false;
    static LocaleMatcher localeMatcher;
    static Map<String, Map<String, String>> code_type_replacement;
    static final SupplementalDataInfo supplementalData;
    static DtdData ldmlDtdData;
    boolean isEnglish;
    SupplementalDataInfo.PluralInfo pluralInfo;
    Relation<String, String> missingTests = Relation.of(new TreeMap(), TreeSet.class);
    static final UnicodeSet DIGITS;
    static final Relation<SupplementalDataInfo.PluralInfo.Count, String> PLURAL_EXCEPTIONS;
    LocaleIDParser localeIDParser = new LocaleIDParser();
    static final Map<String, Set<String>> BCP47_KEY_VALUES;

    public CheckAttributeValues(Factory factory) {
        super(factory);
    }

    @Override
    public void handleFinish() {
        for (Map.Entry<String, Set<String>> entry : this.missingTests.keyValuesSet()) {
            System.out.println("Missing element: " + entry.getKey() + ", attributes: " + String.valueOf(entry.getValue()));
        }
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (fullPath.indexOf(91) < 0) {
            return this;
        }
        String locale = this.getCldrFileToCheck().getSourceLocaleID(path, null);
        if (!this.getCldrFileToCheck().getLocaleID().equals(locale)) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(fullPath);
        for (int i = 0; i < parts.size(); ++i) {
            if (parts.getAttributeCount(i) == 0) continue;
            Map<String, String> attributes = parts.getAttributes(i);
            String element = parts.getElement(i);
            DtdData.Element elementInfo = ldmlDtdData.getElementFromName().get(element);
            Map<String, MatcherPattern> attribute_validity = element_attribute_validity.get(element);
            for (String attribute : attributes.keySet()) {
                DtdData.Attribute attributeInfo = elementInfo.getAttributeNamed(attribute);
                if (!attributeInfo.values.isEmpty()) continue;
                String attributeValue = attributes.get(attribute);
                if (element.equals("type") && attribute.equals("type")) {
                    Set<String> typeValues = BCP47_KEY_VALUES.get(attributes.get("key"));
                    if (typeValues.contains(attributeValue)) continue;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.unexpectedAttributeValue).setMessage("Unexpected Attribute Value {0}={1}: expected: {2}", attribute, attributeValue, typeValues));
                    continue;
                }
                boolean haveTest = this.check(common_attribute_validity, attribute, attributeValue, result);
                boolean bl = haveTest = haveTest || this.check(attribute_validity, attribute, attributeValue, result);
                if (!haveTest && FIND_MISSING) {
                    this.missingTests.put(element, attribute);
                }
                if (!attribute.equals("count") || DIGITS.containsAll(attributeValue)) continue;
                SupplementalDataInfo.PluralInfo.Count countValue = SupplementalDataInfo.PluralInfo.Count.valueOf(attributeValue);
                if (this.pluralInfo.getCounts().contains((Object)countValue) || CheckAttributeValues.isPluralException(countValue, locale)) continue;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalPlural).setMessage("Illegal plural value {0}; must be one of: {1}", new Object[]{countValue, this.pluralInfo.getCounts()}));
            }
        }
        return this;
    }

    static boolean isPluralException(SupplementalDataInfo.PluralInfo.Count countValue, String locale) {
        String base;
        Set<String> exceptions = PLURAL_EXCEPTIONS.get((Object)countValue);
        if (exceptions == null) {
            return false;
        }
        if (exceptions.contains(locale)) {
            return true;
        }
        int bar = locale.indexOf(95);
        return bar > 0 && exceptions.contains(base = locale.substring(0, bar));
    }

    private boolean check(Map<String, MatcherPattern> attribute_validity, String attribute, String attributeValue, List<CheckCLDR.CheckStatus> result) {
        if (attribute_validity == null) {
            return false;
        }
        MatcherPattern matcherPattern = attribute_validity.get(attribute);
        if (matcherPattern == null) {
            return false;
        }
        if (matcherPattern.matcher.test(attributeValue)) {
            return true;
        }
        String replacement = this.getReplacement(matcherPattern.value, attributeValue);
        if (replacement != null) {
            if (this.isEnglish) {
                return true;
            }
            if (replacement.length() == 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.deprecatedAttribute).setMessage("Deprecated Attribute Value {0}={1}. Consider removing.", attribute, attributeValue));
            } else {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.deprecatedAttributeWithReplacement).setMessage("Deprecated Attribute Value {0}={1}. Consider removing, and possibly modifying the related value for {2}.", attribute, attributeValue, replacement));
            }
        } else {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.unexpectedAttributeValue).setMessage("Unexpected Attribute Value {0}={1}: expected: {2}", attribute, attributeValue, matcherPattern.pattern));
        }
        return true;
    }

    String getReplacement(String value, String attributeValue) {
        Map<String, String> type_replacement = code_type_replacement.get(value);
        if (type_replacement == null) {
            return null;
        }
        return type_replacement.get(attributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        if (CheckCLDR.Phase.FINAL_TESTING != this.getPhase() && CheckCLDR.Phase.BUILD != this.getPhase()) {
            this.setSkipTest(true);
            return this;
        }
        this.setSkipTest(false);
        this.pluralInfo = supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, cldrFileToCheck.getLocaleID());
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.isEnglish = "en".equals(this.localeIDParser.set(cldrFileToCheck.getLocaleID()).getLanguage());
        LinkedHashSet<String> linkedHashSet = elementOrder;
        synchronized (linkedHashSet) {
            if (!initialized) {
                this.getMetadata();
                initialized = true;
                localeMatcher = LocaleMatcher.make();
            }
        }
        if (!localeMatcher.test(cldrFileToCheck.getLocaleID())) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidLocale).setMessage("Invalid Locale {0}", cldrFileToCheck.getLocaleID()));
        }
        return this;
    }

    private void getMetadata() {
        MatcherPattern mp;
        String value;
        Map<String, Row.R2<String, String>> rawVariables = supplementalData.getValidityInfo();
        for (Map.Entry<String, Row.R2<String, String>> item : rawVariables.entrySet()) {
            String id = item.getKey();
            String type = (String)item.getValue().get0();
            mp = this.getMatcherPattern2(type, value = (String)item.getValue().get1());
            if (mp == null) continue;
            variables.put(id, mp);
        }
        Map<SupplementalDataInfo.AttributeValidityInfo, String> rawAttributeValueInfo = supplementalData.getAttributeValidity();
        for (Map.Entry<SupplementalDataInfo.AttributeValidityInfo, String> entry : rawAttributeValueInfo.entrySet()) {
            Set<DtdType> dtds;
            SupplementalDataInfo.AttributeValidityInfo item = entry.getKey();
            value = entry.getValue();
            mp = this.getMatcherPattern2(item.getType(), value);
            if (mp == null) {
                System.out.println("Failed to make matcher for: " + String.valueOf(item));
                continue;
            }
            if (FIND_MISSING && mp.matcher == NOT_DONE_YET) {
                this.missingTests.put(item.getElements().toString(), item.getAttributes().toString());
            }
            if (!(dtds = item.getDtds()).contains((Object)DtdType.ldml)) continue;
            Set<String> attributeList = item.getAttributes();
            Set<String> elementList = item.getElements();
            if (elementList.size() == 0) {
                this.addAttributes(attributeList, common_attribute_validity, mp);
                continue;
            }
            for (String element : elementList) {
                DtdData.Element elementInfo = ldmlDtdData.getElementFromName().get(element);
                if (elementInfo == null) {
                    System.out.println("Illegal <attributeValues>, element not valid: element: " + element);
                } else {
                    for (String attribute : attributeList) {
                        DtdData.Attribute attributeInfo = elementInfo.getAttributeNamed(attribute);
                        if (attributeInfo == null) {
                            System.out.println("Illegal <attributeValues>, attribute not valid: element: " + element + ", attribute: " + attribute);
                            continue;
                        }
                        if (attributeInfo.values.isEmpty()) continue;
                    }
                }
                Map<String, MatcherPattern> attribute_validity = element_attribute_validity.get(element);
                if (attribute_validity == null) {
                    attribute_validity = new TreeMap<String, MatcherPattern>();
                    element_attribute_validity.put(element, attribute_validity);
                }
                this.addAttributes(attributeList, attribute_validity, mp);
            }
        }
    }

    private MatcherPattern getBcp47MatcherPattern(String key) {
        MatcherPattern m4 = new MatcherPattern();
        Set<String> values = key.equals("key") ? BCP47_KEY_VALUES.keySet() : BCP47_KEY_VALUES.get(key);
        m4.value = key;
        m4.pattern = values.toString();
        m4.matcher = new CollectionMatcher().set(values);
        return m4;
    }

    private MatcherPattern getMatcherPattern2(String type, String value) {
        String typeAttribute = type;
        MatcherPattern result = variables.get(value);
        if (result != null) {
            MatcherPattern temp = new MatcherPattern();
            temp.pattern = result.pattern;
            temp.matcher = result.matcher;
            temp.value = value;
            result = temp;
            if ("list".equals(typeAttribute)) {
                temp.matcher = new ListMatcher().set(result.matcher);
            }
            return result;
        }
        result = new MatcherPattern();
        result.pattern = value;
        result.value = value;
        if ("choice".equals(typeAttribute)) {
            result.matcher = new CollectionMatcher().set(new HashSet<String>(Arrays.asList(value.trim().split("\\s+"))));
        } else if ("bcp47".equals(typeAttribute)) {
            result = this.getBcp47MatcherPattern(value);
        } else if ("regex".equals(typeAttribute)) {
            result.matcher = new RegexMatcher().set(value, 4);
        } else if ("locale".equals(typeAttribute)) {
            result.matcher = LocaleMatcher.make();
        } else if ("notDoneYet".equals(typeAttribute) || "notDoneYet".equals(value)) {
            result.matcher = NOT_DONE_YET;
        } else {
            System.out.println("unknown type; value: <" + value + ">,\t" + typeAttribute);
            return null;
        }
        return result;
    }

    private void addAttributes(Set<String> attributes, Map<String, MatcherPattern> attribute_validity, MatcherPattern mp) {
        for (String attribute : attributes) {
            MatcherPattern old = attribute_validity.get(attribute);
            if (old != null) {
                mp.matcher = new OrMatcher().set(old.matcher, mp.matcher);
                mp.pattern = old.pattern + " OR " + mp.pattern;
            }
            attribute_validity.put(attribute, mp);
        }
    }

    static {
        code_type_replacement = new TreeMap<String, Map<String, String>>();
        supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
        ldmlDtdData = DtdData.getInstance(DtdType.ldml);
        DIGITS = new UnicodeSet("[0-9]").freeze();
        PLURAL_EXCEPTIONS = Relation.of(new EnumMap(SupplementalDataInfo.PluralInfo.Count.class), HashSet.class);
        PLURAL_EXCEPTIONS.put(SupplementalDataInfo.PluralInfo.Count.many, "hr");
        PLURAL_EXCEPTIONS.put(SupplementalDataInfo.PluralInfo.Count.many, "sr");
        PLURAL_EXCEPTIONS.put(SupplementalDataInfo.PluralInfo.Count.many, "sh");
        PLURAL_EXCEPTIONS.put(SupplementalDataInfo.PluralInfo.Count.many, "bs");
        PLURAL_EXCEPTIONS.put(SupplementalDataInfo.PluralInfo.Count.few, "ru");
        HashMap<String, Set> temp = new HashMap<String, Set>();
        Relation<Row.R2<String, String>, String> bcp47Aliases = supplementalData.getBcp47Aliases();
        for (Map.Entry<String, Set<String>> keyValues : supplementalData.getBcp47Keys().keyValuesSet()) {
            Set<String> fullValues = new TreeSet<String>();
            String key = keyValues.getKey();
            Set<String> rawValues = keyValues.getValue();
            for (String value : rawValues) {
                Row.R2<String, String> keyValue;
                Set<String> aliases;
                if (key.equals("cu")) {
                    fullValues.add(value.toUpperCase());
                } else {
                    fullValues.add(value);
                }
                if ((aliases = bcp47Aliases.getAll(keyValue = Row.R2.of(key, value))) == null) continue;
                fullValues.addAll(aliases);
            }
            if (key.equals("ca")) {
                fullValues.add("generic");
            }
            fullValues = Collections.unmodifiableSet(fullValues);
            temp.put(key, fullValues);
            Set<String> aliases = supplementalData.getBcp47Aliases().getAll(Row.of(key, ""));
            if (aliases != null) {
                for (String aliasKey : aliases) {
                    temp.put(aliasKey, fullValues);
                }
            }
            temp.put("x", Collections.EMPTY_SET);
        }
        BCP47_KEY_VALUES = Collections.unmodifiableMap(temp);
    }

    public static class LocaleMatcher
    implements Predicate<String> {
        Predicate<String> legacy;
        Predicate<String> language;
        Predicate<String> script;
        Predicate<String> territory;
        Predicate<String> variant;
        LocaleIDParser lip;

        private LocaleMatcher() {
            this.legacy = CheckAttributeValues.variables.get((Object)"$grandfathered").matcher;
            this.language = CheckAttributeValues.variables.get((Object)"$language").matcher;
            this.script = CheckAttributeValues.variables.get((Object)"$script").matcher;
            this.territory = CheckAttributeValues.variables.get((Object)"$territory").matcher;
            this.variant = CheckAttributeValues.variables.get((Object)"$variant").matcher;
            this.lip = new LocaleIDParser();
        }

        public static LocaleMatcher make() {
            return LocaleMatcherHelper.SINGLETON;
        }

        @Override
        public boolean test(String value) {
            if (this.legacy.test(value)) {
                return true;
            }
            this.lip.set(value);
            String field = this.lip.getLanguage();
            if (!this.language.test(field)) {
                return false;
            }
            field = this.lip.getScript();
            if (field.length() != 0 && !this.script.test(field)) {
                return false;
            }
            field = this.lip.getRegion();
            if (field.length() != 0 && !this.territory.test(field)) {
                return false;
            }
            String[] fields = this.lip.getVariants();
            for (int i = 0; i < fields.length; ++i) {
                if (this.variant.test(fields[i])) continue;
                return false;
            }
            return true;
        }

        private static final class LocaleMatcherHelper {
            static LocaleMatcher SINGLETON = new LocaleMatcher();

            private LocaleMatcherHelper() {
            }
        }
    }

    public static class ListMatcher
    implements Predicate<String> {
        private Predicate<String> other;

        public Predicate<String> set(Predicate<String> other) {
            this.other = other;
            return this;
        }

        @Override
        public boolean test(String value) {
            String[] values = value.trim().split("\\s+");
            if (values.length == 1 && values[0].length() == 0) {
                return true;
            }
            for (int i = 0; i < values.length; ++i) {
                if (this.other.test(values[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class OrMatcher
    implements Predicate<String> {
        private Predicate<String> a;
        private Predicate<String> b;

        public Predicate<String> set(Predicate<String> a, Predicate<String> b) {
            this.a = a;
            this.b = b;
            return this;
        }

        @Override
        public boolean test(String value) {
            return this.a.test(value) || this.b.test(value);
        }
    }

    public static class CollectionMatcher
    implements Predicate<String> {
        private Collection<String> collection;

        public Predicate<String> set(Collection<String> collection) {
            this.collection = collection;
            return this;
        }

        @Override
        public boolean test(String value) {
            return this.collection.contains(value);
        }
    }

    public static class RegexMatcher
    implements Predicate<String> {
        private Matcher matcher;

        public Predicate<String> set(String pattern) {
            this.matcher = PatternCache.get(pattern).matcher("");
            return this;
        }

        public Predicate<String> set(String pattern, int flags) {
            this.matcher = Pattern.compile(pattern, flags).matcher("");
            return this;
        }

        @Override
        public boolean test(String value) {
            this.matcher.reset(value.toString());
            return this.matcher.matches();
        }
    }

    private static class MatcherPattern {
        public String value;
        Predicate<String> matcher;
        String pattern;

        private MatcherPattern() {
        }

        public String toString() {
            return this.matcher.getClass().getName() + "\t" + this.pattern;
        }
    }
}

