/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.ibm.icu.util.Output;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class CompareResolved {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = CLDR_CONFIG.getSupplementalDataInfo();

    public static void main(String[] args) {
        Factory compareFactory;
        MyOptions.parse(args);
        String sourceDir = MyOptions.source.option.getValue();
        String compareDir = MyOptions.compare.option.getValue();
        Matcher fileMatcher = null;
        String pattern = MyOptions.fileFilter.option.getValue();
        if (pattern != null) {
            fileMatcher = Pattern.compile(pattern).matcher("");
        }
        Matcher pathMatcher = null;
        pattern = MyOptions.pathFilter.option.getValue();
        if (pattern != null) {
            pathMatcher = Pattern.compile(pattern).matcher("");
        }
        boolean verbose = MyOptions.verbose.option.doesOccur();
        Factory sourceFactory = Factory.make(sourceDir, ".*");
        try {
            compareFactory = Factory.make(compareDir, ".*");
        }
        catch (Exception e1) {
            System.out.println(e1);
            return;
        }
        System.out.println("## Comparing\t\tSource (S) dir\tCompare (C) dir");
        System.out.println("## Comparing\t\t" + sourceDir + "\t" + compareDir);
        Output<String> sourcePathFound = new Output<String>();
        Output<String> sourceLocaleFound = new Output<String>();
        Output<String> comparePathFound = new Output<String>();
        Output<String> compareLocaleFound = new Output<String>();
        int filterCountAllLocales = 0;
        int diffCountAllLocales = 0;
        System.out.println("## Locale\tRequested Path\tResolved Value (S)\tResolved Value (C)\tFound Locale (S)\tFound Locale (C)\tFound Path (S)\tFound Path (C)");
        for (String localeID : sourceFactory.getAvailable()) {
            CLDRFile compareFile;
            if (fileMatcher != null && !fileMatcher.reset(localeID).find()) continue;
            CLDRFile sourceFile = sourceFactory.make(localeID, true);
            try {
                compareFile = compareFactory.make(localeID, true);
            }
            catch (Exception e) {
                System.out.println(localeID + " not available in " + compareDir);
                continue;
            }
            TreeSet<String> sortedPaths = new TreeSet<String>();
            sortedPaths.addAll(Sets.newTreeSet(sourceFile));
            sortedPaths.addAll(Sets.newTreeSet(compareFile));
            int filterCount = 0;
            int diffCount = 0;
            for (String path : sortedPaths) {
                String compareValue;
                if (pathMatcher != null && !pathMatcher.reset(path).find()) continue;
                ++filterCount;
                String sourceValue = sourceFile.getStringValueWithBailey(path, sourcePathFound, sourceLocaleFound);
                if (Objects.equal(sourceValue, compareValue = compareFile.getStringValueWithBailey(path, comparePathFound, compareLocaleFound))) continue;
                boolean verticalDiff = !Objects.equal(sourceLocaleFound.value, compareLocaleFound.value);
                boolean horizontalDiff = !Objects.equal(sourcePathFound.value, comparePathFound.value);
                ++diffCount;
                System.out.println(localeID + "\t" + path + "\t" + sourceValue + "\t" + compareValue + "\t" + (String)sourceLocaleFound.value + "\t" + (String)compareLocaleFound.value + "\t" + CompareResolved.abbreviate((String)sourcePathFound.value, path) + "\t" + CompareResolved.abbreviate((String)comparePathFound.value, path));
            }
            if (verbose || diffCount != 0) {
                System.out.println("# " + localeID + "\tfilteredCount:\t" + filterCount + "\tdiffCount:\t" + diffCount);
            }
            filterCountAllLocales += filterCount;
            diffCountAllLocales += diffCount;
        }
        if (verbose || diffCountAllLocales != 0) {
            System.out.println("# ALL LOCALES\t#filteredCount:\t" + filterCountAllLocales + ", diffCountAllLocales: " + diffCountAllLocales);
        }
        System.out.println("DONE");
    }

    private static String abbreviate(String pathToAbbreviate, String referencePath) {
        int trailingSame;
        int initialSame;
        if (pathToAbbreviate.equals(referencePath)) {
            return "\u2026";
        }
        XPathParts compare = XPathParts.getFrozenInstance(pathToAbbreviate);
        XPathParts source = XPathParts.getFrozenInstance(referencePath);
        int cSize = compare.size();
        int sSize = source.size();
        int min2 = Math.min(cSize, sSize);
        for (initialSame = 0; initialSame < min2; ++initialSame) {
            String cElement = compare.getElement(initialSame);
            String sElement = source.getElement(initialSame);
            Map<String, String> cAttributes = compare.getAttributes(initialSame);
            Map<String, String> sAttributes = source.getAttributes(initialSame);
            if (!cElement.equals(sElement) || !cAttributes.equals(sAttributes)) break;
        }
        int cDelta = -1;
        int sDelta = sSize - cSize - 1;
        for (trailingSame = cSize; trailingSame > initialSame; --trailingSame) {
            String cElement = compare.getElement(trailingSame + cDelta);
            String sElement = source.getElement(trailingSame + sDelta);
            Map<String, String> cAttributes = compare.getAttributes(trailingSame + cDelta);
            Map<String, String> sAttributes = source.getAttributes(trailingSame + sDelta);
            if (!cElement.equals(sElement) || !cAttributes.equals(sAttributes)) break;
        }
        return "\u2026" + compare.toString(initialSame, trailingSame) + (trailingSame == cSize ? "" : "\u2026");
    }

    private static enum MyOptions {
        source(new Option.Params().setHelp("Set the source directory name. Only these files will be compared").setDefault(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-42.0/common/main").setMatch(".*")),
        compare(new Option.Params().setHelp("Set the comparison directory name.").setMatch(".*").setDefault(CLDRPaths.MAIN_DIRECTORY)),
        fileFilter(new Option.Params().setHelp("Filter files in source dir.").setMatch(".*")),
        pathFilter(new Option.Params().setHelp("Filter paths in each source file.").setMatch(".*")),
        verbose(new Option.Params().setMatch(null));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

