/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.XPathParts;

public enum RbnfData {
    INSTANCE;

    private final Map<String, Multimap<String, String>> localeToTypesToSubtypes;
    private final Multimap<String, String> rbnfTypeToLocales;

    private RbnfData() {
        TreeMap<String, TreeMultimap<String, String>> _localeToRbnfType = new TreeMap<String, TreeMultimap<String, String>>();
        TreeMultimap<String, String> _rbnfTypeToLocales = TreeMultimap.create();
        Factory factory = CLDRConfig.getInstance().getRBNFFactory();
        for (String locale : factory.getAvailable()) {
            CLDRFile cldrFile = factory.make(locale, false);
            TreeMultimap<String, String> typeToSubtype = (TreeMultimap<String, String>)_localeToRbnfType.get(locale);
            if (typeToSubtype == null) {
                typeToSubtype = TreeMultimap.create();
                _localeToRbnfType.put(locale, typeToSubtype);
            }
            for (String dpath : cldrFile) {
                String rbnfSubtype;
                String rbnfType;
                String path = cldrFile.getFullXPath(dpath);
                XPathParts parts = XPathParts.getFrozenInstance(path);
                if (!"rbnf".equals(parts.getElement(1)) || !"ruleset".equals(parts.getElement(3)) || "private".equals(parts.getAttributeValue(3, "access"))) continue;
                String fullType = parts.getAttributeValue(3, "type");
                if (fullType.startsWith("spellout") || fullType.startsWith("digits")) {
                    int index2 = fullType.indexOf(45, fullType.indexOf(45) + 1);
                    if (index2 == -1) {
                        rbnfType = fullType;
                        rbnfSubtype = "DEFAULT";
                    } else {
                        rbnfType = fullType.substring(0, index2);
                        rbnfSubtype = fullType.substring(index2 + 1);
                    }
                } else {
                    rbnfType = "UNKNOWN";
                    rbnfSubtype = fullType;
                }
                typeToSubtype.put(rbnfType, rbnfSubtype);
                _rbnfTypeToLocales.put(rbnfType, locale);
            }
        }
        this.localeToTypesToSubtypes = CldrUtility.protectCollection(_localeToRbnfType);
        this.rbnfTypeToLocales = CldrUtility.protectCollection(_rbnfTypeToLocales);
    }

    public Multimap<String, String> getRbnfTypeToLocales() {
        return this.rbnfTypeToLocales;
    }

    public Map<String, Multimap<String, String>> getLocaleToTypesToSubtypes() {
        return this.localeToTypesToSubtypes;
    }

    public String getPath(String rbnfType) {
        return "//ldml/rbnf/rulesetGrouping[@type=\"SpelloutRules\"]/ruleset[@type=\"" + rbnfType + "\"]";
    }
}

