/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import org.unicode.cldr.util.XPathValue;

public abstract class XPathParser
implements XPathValue {
    protected void handleParse(String xPath, boolean initial) {
        String lastAttributeName = "";
        String requiredPrefix = "/";
        if (initial) {
            this.handleClearElements();
            requiredPrefix = "//";
        }
        if (!xPath.startsWith(requiredPrefix)) {
            this.parseError(xPath, 0);
        }
        int stringStart = requiredPrefix.length();
        int state = 112;
        int len = xPath.length();
        block8: for (int i = 2; i < len; ++i) {
            int cp = xPath.charAt(i);
            if (cp != state && (state == 34 || state == 39)) continue;
            switch (cp) {
                case 47: {
                    if (state != 112 || stringStart >= i) {
                        this.parseError(xPath, i);
                    }
                    if (stringStart > 0) {
                        this.handleAddElement(xPath.substring(stringStart, i));
                    }
                    stringStart = i + 1;
                    continue block8;
                }
                case 91: {
                    if (state != 112 || stringStart >= i) {
                        this.parseError(xPath, i);
                    }
                    if (stringStart > 0) {
                        this.handleAddElement(xPath.substring(stringStart, i));
                    }
                    state = cp;
                    continue block8;
                }
                case 64: {
                    if (state != 91) {
                        this.parseError(xPath, i);
                    }
                    stringStart = i + 1;
                    state = cp;
                    continue block8;
                }
                case 61: {
                    if (state != 64 || stringStart >= i) {
                        this.parseError(xPath, i);
                    }
                    lastAttributeName = xPath.substring(stringStart, i);
                    state = cp;
                    continue block8;
                }
                case 34: 
                case 39: {
                    if (state == cp) {
                        if (stringStart > i) {
                            this.parseError(xPath, i);
                        }
                        this.handleAddAttribute(lastAttributeName, xPath.substring(stringStart, i));
                        state = 101;
                        continue block8;
                    }
                    if (state != 61) {
                        this.parseError(xPath, i);
                    }
                    stringStart = i + 1;
                    state = cp;
                    continue block8;
                }
                case 93: {
                    if (state != 101) {
                        this.parseError(xPath, i);
                    }
                    state = 112;
                    stringStart = -1;
                }
            }
        }
        if (state != 112 || stringStart >= xPath.length()) {
            this.parseError(xPath, xPath.length());
        }
        if (stringStart > 0) {
            this.handleAddElement(xPath.substring(stringStart, xPath.length()));
        }
    }

    protected void parseError(String s2, int i) {
        throw new IllegalArgumentException("Malformed xPath '" + s2 + "' at " + i);
    }

    protected abstract void handleClearElements();

    protected abstract void handleAddElement(String var1);

    protected abstract void handleAddAttribute(String var1, String var2);
}

