/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.unicode.cldr.test.ExampleDependencies;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.ThreadSafeMapOfMapOfMap;

public class ExampleCache {
    private static final boolean AVOID_CLEARING_CACHE = true;
    private static final String NONE = "\uffff";
    private final ThreadSafeMapOfMapOfMap<String, String, String, String> cache = new ThreadSafeMapOfMapOfMap();
    private final Multimap<String, ClearableCache> registeredCache = HashMultimap.create();
    private boolean cachingIsEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends ClearableCache> T registerCache(T clearableCache, String ... starredPaths) {
        Multimap<String, ClearableCache> multimap = this.registeredCache;
        synchronized (multimap) {
            for (String starredPath : starredPaths) {
                this.registeredCache.put(starredPath, clearableCache);
            }
            return clearableCache;
        }
    }

    public void setCachingEnabled(boolean enabled) {
        this.cachingIsEnabled = enabled;
    }

    public String computeIfAbsent(String xpath, String value, ThreadSafeMapOfMapOfMap.TriFunction<String, String, String, String> f) {
        String starredPath = PathStarrer.get(xpath);
        if (!this.cachingIsEnabled) {
            return f.apply(starredPath, xpath, value);
        }
        return this.cache.computeIfAbsent(starredPath, xpath, value, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(String xpath) {
        String starredA = PathStarrer.get(xpath);
        for (String starredB : ExampleDependencies.dependencies.get((Object)starredA)) {
            this.cache.remove(starredB, null, null);
        }
        Multimap<String, ClearableCache> multimap = this.registeredCache;
        synchronized (multimap) {
            for (ClearableCache item : this.registeredCache.get(starredA)) {
                item.clear();
            }
        }
    }

    static interface ClearableCache {
        public void clear();
    }
}

