/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.StandardCodes;

public class GenerateBcp47Bits {
    static final boolean QUICK = false;
    static long[] javaTestRegions = new long[0];
    static long[] javaTestLanguages = new long[0];

    public static void main(String[] args) {
        Set<String> languages = Iso639Data.getAvailable();
        long[] languageStaticTest = null;
        Set<String> regions = StandardCodes.make().getAvailableCodes("territory");
        long[] regionStaticTest = null;
        System.out.println("\t<bits>");
        GenerateBcp47Bits.writeInfo("region", regions, new Bcp47StringBitTransform(Bcp47StringBitTransform.Type.REGION), regionStaticTest);
        GenerateBcp47Bits.writeInfo("language", languages, new Bcp47StringBitTransform(Bcp47StringBitTransform.Type.LANGUAGE), languageStaticTest);
        System.out.println("\t</bits>");
    }

    private static void writeInfo(String element, Collection<String> codes, StringBitTransform transform, long[] testStatic) {
        System.out.println("<!-- " + String.valueOf(codes) + " -->");
        System.out.println("\t\t<" + element + ">");
        GenerateBcp47Bits.writeBits(codes, transform, "\t\t\t\t", testStatic);
        System.out.println("\t\t</" + element + ">");
    }

    private static void writeBits(Collection<String> source, StringBitTransform transform, String indent, long[] testStatic) {
        Bits staticTest;
        TreeSet<String> codes = new TreeSet<String>(source);
        Bits bits = new Bits(transform.getLimit());
        for (String code : codes) {
            int bit = transform.toBit(code);
            String verify = transform.fromBit(bit);
            bits.set(bit);
            if (!verify.equalsIgnoreCase(code)) {
                bit = transform.toBit(code);
                verify = transform.fromBit(bit);
                throw new IllegalArgumentException("StringBitTransform failure with " + code);
            }
            if (bits.get(bit)) continue;
            throw new IllegalArgumentException("Bit failure with " + code);
        }
        TreeSet<String> verifySet = new TreeSet<String>();
        for (int i = 0; i < transform.getLimit(); ++i) {
            if (!bits.get(i)) continue;
            String verify = transform.fromBit(i);
            verifySet.add(verify);
        }
        if (!verifySet.equals(codes)) {
            throw new IllegalArgumentException("Roundtrip failure with " + ((Object)verifySet).toString());
        }
        String stringForm = bits.toString(16, indent, 4);
        System.out.println(stringForm);
        Bits reversed = Bits.fromString(transform.getLimit(), stringForm, 16);
        if (!reversed.equals(bits)) {
            throw new IllegalArgumentException("Reversal failure" + String.valueOf(bits) + " != " + String.valueOf(reversed));
        }
        if (testStatic != null && !(staticTest = Bits.fromInts(transform.getLimit(), testStatic)).equals(bits)) {
            throw new IllegalArgumentException("Static failure");
        }
    }

    static class Bcp47StringBitTransform
    implements StringBitTransform {
        Type type;
        int limit;
        static final UnicodeSet alpha = new UnicodeSet("[a-z]").freeze();
        static final UnicodeSet num = new UnicodeSet("[0-9]").freeze();

        Bcp47StringBitTransform(Type type) {
            this.type = type;
            this.limit = type == Type.LANGUAGE ? 18252 : 1676;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public int toBit(String string) {
            string = UCharacter.toLowerCase(ULocale.ENGLISH, string);
            switch (string.length()) {
                case 2: {
                    if (!alpha.containsAll(string)) {
                        throw new IllegalArgumentException(string);
                    }
                    return (string.codePointAt(0) - 97) * 26 + (string.codePointAt(1) - 97);
                }
                case 3: {
                    if (alpha.containsAll(string)) {
                        return 676 + (string.codePointAt(0) - 97) * 26 * 26 + (string.codePointAt(1) - 97) * 26 + (string.codePointAt(2) - 97);
                    }
                    if (!num.containsAll(string)) {
                        throw new IllegalArgumentException(string);
                    }
                    return 676 + Integer.parseInt(string);
                }
            }
            throw new IllegalArgumentException(string);
        }

        @Override
        public String fromBit(int bit) {
            StringBuilder result = new StringBuilder();
            if (bit < 0) {
                throw new IllegalArgumentException(String.valueOf(bit));
            }
            if (bit < 676) {
                result.appendCodePoint(97 + bit / 26).appendCodePoint(97 + bit % 26);
            } else {
                bit -= 676;
                if (this.type == Type.LANGUAGE) {
                    if (bit >= 18252) {
                        throw new IllegalArgumentException(String.valueOf(bit));
                    }
                    result.appendCodePoint(97 + bit / 676);
                    result.appendCodePoint(97 + (bit %= 676) / 26).appendCodePoint(97 + bit % 26);
                } else {
                    if (bit >= 1676) {
                        throw new IllegalArgumentException(String.valueOf(bit));
                    }
                    result.append(bit / 100);
                    result.append((bit %= 100) / 10).append(bit % 10);
                }
            }
            if (this.type == Type.REGION) {
                return result.toString().toUpperCase(Locale.ENGLISH);
            }
            return result.toString();
        }

        static enum Type {
            LANGUAGE,
            REGION;

        }
    }

    static interface StringBitTransform {
        public int getLimit();

        public int toBit(String var1);

        public String fromBit(int var1);
    }

    static class Bits {
        private final long[] bits;
        static final int SHIFT = 6;
        static final int MASK = 63;

        Bits(int size) {
            this.bits = new long[(size - 1 >> 6) + 1];
        }

        public Bits set(int bit) {
            int index = bit >> 6;
            int remainder = bit & 0x3F;
            long mask = 1L << remainder;
            int n = index;
            this.bits[n] = this.bits[n] | mask;
            return this;
        }

        public boolean get(int bit) {
            int index = bit >> 6;
            int remainder = bit & 0x3F;
            long mask = 1L << remainder;
            long masked = this.bits[index] & mask;
            return 0L != masked;
        }

        public String toString(int radix, String indent, int perLineMax) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(indent);
            int count = perLineMax;
            int last = this.bits.length;
            while (this.bits[--last] == 0L) {
            }
            for (int i = 0; i <= last; ++i) {
                if (i != 0) {
                    if (--count == 0) {
                        buffer.append(",\n");
                        buffer.append(indent);
                        count = perLineMax;
                    } else {
                        buffer.append(", ");
                    }
                }
                buffer.append(Long.toString(this.bits[i], radix));
            }
            return buffer.toString();
        }

        static Bits fromString(int size, String value, int radix) {
            String[] parts = value.trim().split(",\\s*|\\s+");
            if (parts.length > size) {
                throw new IllegalArgumentException("Too many integers");
            }
            Bits result = new Bits(size);
            for (int i = 0; i < parts.length; ++i) {
                result.bits[i] = Long.parseLong(parts[i], radix);
            }
            return result;
        }

        static Bits fromInts(int size, long[] ints) {
            Bits result = new Bits(size);
            if (ints.length > result.bits.length) {
                throw new IllegalArgumentException("Too many integers");
            }
            for (int i = 0; i < ints.length; ++i) {
                result.bits[i] = ints[i];
            }
            return result;
        }

        public boolean equals(Bits other) {
            if (this.bits.length != other.bits.length) {
                return false;
            }
            for (int i = 0; i < this.bits.length; ++i) {
                if (this.bits[i] == other.bits[i]) continue;
                return false;
            }
            return true;
        }

        public int firstDifference(Bits other) {
            int limit = other.bits.length;
            if (limit < this.bits.length) {
                limit = this.bits.length;
            }
            limit <<= 6;
            for (int i = 0; i < limit; ++i) {
                if (this.get(i) == other.get(i)) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("[");
            int limit = this.bits.length;
            limit <<= 6;
            for (int i = 0; i < limit; ++i) {
                if (!this.get(i)) continue;
                if (result.length() > 1) {
                    result.append(",");
                }
                result.append(i);
            }
            result.append("]");
            return result.toString();
        }
    }
}

