/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringRange;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.Validity;

@CLDRTool(alias="generate-validity-data", url="http://cldr.unicode.org/development/updating-codes/update-validity-xml")
public class GenerateValidityXml {
    private static final Validity VALIDITY = Validity.getInstance();
    private static Validity OLD_VALIDITY = Validity.getInstance(CLDRPaths.LAST_RELEASE_DIRECTORY + "common/validity/");
    private static final Map<StandardCodes.LstrType, Map<String, Map<StandardCodes.LstrField, String>>> LSTREG = StandardCodes.getEnumLstreg();
    private static final SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();
    static Set<String> containment = SDI.getContainers();
    static Map<String, Map<StandardCodes.LstrField, String>> codeToData = LSTREG.get((Object)StandardCodes.LstrType.region);
    static final Map<String, Info> types = Info.types;
    static final Set<String> VARIANTS = Set.of("Aran", "Cyrs", "Hans", "Hant", "Latf", "Latg", "Syre", "Syrj", "Syrn", "Hanb", "Jpan", "Hrkt", "Kore", "Hntl", "Jamo");
    static final Set<String> VARIANT_EXTRAS = ImmutableSet.of("POSIX", "REVISED", "SAAHO");

    public static void main(String[] args) throws IOException {
        GenerateValidityXml.doLstr(types);
        GenerateValidityXml.doSubdivisions(types);
        GenerateValidityXml.doCurrency(types);
        MyAdder adder = new MyAdder();
        for (Map.Entry<String, Info> entry : types.entrySet()) {
            String type = entry.getKey();
            Info info = entry.getValue();
            SetMultimap<Validity.Status, String> subtypeMap = info.getStatusMap();
            TempPrintWriter output = TempPrintWriter.openUTF8Writer(CLDRPaths.COMMON_DIRECTORY, "validity/" + type + ".xml").skipCopyright(true);
            try {
                adder.target = output;
                output.append(DtdType.supplementalData.header(MethodHandles.lookup().lookupClass()) + "\t<version number=\"$Revision$\"/>\n\t<idValidity>\n");
                for (Map.Entry entry2 : subtypeMap.asMap().entrySet()) {
                    Validity.Status subtype = (Validity.Status)((Object)entry2.getKey());
                    Set set = (Set)entry2.getValue();
                    String comment = info.statusComment.get(entry2.getKey());
                    if (comment != null) {
                        output.append("\t\t<!-- " + comment.replace("\n", "\n\t\t\t ") + " -->\n");
                    }
                    output.append("\t\t<id type='" + type + "' idStatus='" + String.valueOf((Object)subtype) + "'>");
                    int size = set.size();
                    output.append("\t\t<!-- " + size + " item" + (size > 1 ? "s" : "") + " -->");
                    adder.reset(size > 600);
                    StringRange.compact(set, adder, true);
                    output.append("\n\t\t</id>\n");
                }
                output.append("\t</idValidity>\n</supplementalData>\n");
            }
            finally {
                if (output == null) continue;
                output.close();
            }
        }
    }

    private static String showCodes(Set<String> newCodes, String linePrefix) {
        StringBuilder result = new StringBuilder();
        String last = "";
        for (String s2 : newCodes) {
            String newPrefix = s2.substring(0, s2.indexOf(45));
            if (last.equals(newPrefix)) {
                result.append(" ");
            } else {
                if (!last.isEmpty()) {
                    result.append(linePrefix);
                }
                last = newPrefix;
            }
            result.append(s2);
        }
        return result.toString();
    }

    private static void doCurrency(Map<String, Info> types) {
        Info info = Info.getInfo("currency");
        Date now = new Date();
        Date eoy = new Date(now.getYear() + 1, 0, 1);
        for (String region : SDI.getCurrencyTerritories()) {
            for (SupplementalDataInfo.CurrencyDateInfo data : SDI.getCurrencyDateInfo(region)) {
                String currency = data.getCurrency();
                Date end = data.getEnd();
                boolean legalTender = data.isLegalTender();
                Validity.Status newStatus = end.after(eoy) && legalTender ? Validity.Status.regular : Validity.Status.deprecated;
                info.putBest(currency, newStatus);
            }
        }
        info.put(StandardCodes.LstrType.currency.unknown, Validity.Status.unknown);
        info.remove("XXX", Validity.Status.deprecated);
        info.remove("XXX", Validity.Status.regular);
        Map<String, Validity.Status> oldCodes = OLD_VALIDITY.getCodeToStatus(StandardCodes.LstrType.currency);
        for (Map.Entry<String, Validity.Status> entry : oldCodes.entrySet()) {
            Validity.Status newStatus;
            String key = entry.getKey();
            Validity.Status oldStatus = entry.getValue();
            if (Objects.equal((Object)oldStatus, (Object)(newStatus = info.get(key)))) continue;
            System.out.println("Status changed: " + key + ", " + String.valueOf((Object)oldStatus) + " => " + String.valueOf((Object)newStatus));
        }
        info.statusComment.put(Validity.Status.deprecated, "Deprecated values are those that are not legal tender in some country after " + (1900 + now.getYear()) + ".\nMore detailed usage information needed for some implementations is in supplemental data.");
    }

    private static void doSubdivisions(Map<String, Info> types) {
        Info info = Info.getInfo("subdivision");
        Map<String, Row.R2<List<String>, String>> aliases = SDI.getLocaleAliasInfo().get("subdivision");
        for (String container : SDI.getContainersForSubdivisions()) {
            for (String contained : SDI.getContainedSubdivisions(container)) {
                Validity.Status status = aliases.containsKey(contained) ? Validity.Status.deprecated : Validity.Status.regular;
                info.put(contained.toLowerCase(Locale.ROOT).replace("-", ""), status);
            }
        }
        Map<Validity.Status, Set<String>> oldSubdivisionData = OLD_VALIDITY.getStatusToCodes(StandardCodes.LstrType.subdivision);
        for (Map.Entry<Validity.Status, Set<String>> entry : oldSubdivisionData.entrySet()) {
            for (String oldSdId : entry.getValue()) {
                if (info.get(oldSdId) != null) continue;
                info.put(oldSdId, Validity.Status.deprecated);
            }
        }
        info.statusComment.put(Validity.Status.deprecated, "Deprecated values include those that are not formally deprecated in the country in question, but have their own region codes.\nIt also include codes that were previously in CLDR, for compatibility.");
        info.statusComment.put(Validity.Status.unknown, "Unknown/Undetermined subdivision codes (ZZZZ) are defined for all regular region codes.");
    }

    private static void doLstr(Map<String, Info> types) throws IOException {
        TreeSet<String> skippedScripts = new TreeSet<String>();
        for (Map.Entry<StandardCodes.LstrType, Map<String, Map<StandardCodes.LstrField, String>>> entry : LSTREG.entrySet()) {
            StandardCodes.LstrType type = entry.getKey();
            if (!type.isLstr || !type.isUnicode) continue;
            Info info = Info.getInfo(type.toString());
            Map<String, Row.R2<List<String>, String>> aliases = SDI.getLocaleAliasInfo().get(type == StandardCodes.LstrType.region ? "territory" : type.toString());
            if (aliases == null) {
                System.out.println("No aliases for: " + String.valueOf((Object)type));
            }
            info.clear();
            block24: for (Map.Entry<String, Map<StandardCodes.LstrField, String>> entry2 : entry.getValue().entrySet()) {
                String code = entry2.getKey();
                if (type == StandardCodes.LstrType.language && code.equals("aam") || type == StandardCodes.LstrType.variant && code.equals("arevela") || type == StandardCodes.LstrType.extlang && code.equals("lsg")) {
                    boolean bl = false;
                }
                Map<StandardCodes.LstrField, String> data = entry2.getValue();
                Validity.Status subtype = Validity.Status.regular;
                if (code.equals(type.unknown)) {
                    subtype = Validity.Status.unknown;
                } else if (type.specials.contains(code)) {
                    subtype = Validity.Status.special;
                } else if (aliases != null && aliases.containsKey(code) || data.containsKey((Object)StandardCodes.LstrField.Deprecated)) {
                    subtype = Validity.Status.deprecated;
                } else if (data.get((Object)StandardCodes.LstrField.Description).startsWith("Private use")) {
                    subtype = Validity.Status.private_use;
                }
                block0 : switch (type) {
                    case language: {
                        if (subtype == Validity.Status.private_use && code.compareTo("qfz") < 0) {
                            subtype = Validity.Status.reserved;
                            break;
                        }
                        if (!code.equals("root")) break;
                        continue block24;
                    }
                    case region: {
                        if (containment.contains(code)) {
                            subtype = Validity.Status.macroregion;
                        } else if (code.equals("XA") || code.equals("XB")) {
                            subtype = Validity.Status.special;
                        }
                        switch (subtype) {
                            case regular: {
                                Info subInfo = Info.getInfo("subdivision");
                                subInfo.put(code.toLowerCase(Locale.ROOT) + "zzzz", Validity.Status.unknown);
                                break block0;
                            }
                            case private_use: {
                                if (code.compareTo("X") >= 0) break block0;
                                subtype = Validity.Status.reserved;
                                break block0;
                            }
                        }
                        break;
                    }
                    case script: {
                        switch (code) {
                            case "Qaag": 
                            case "Zinh": 
                            case "Zsye": 
                            case "Zyyy": {
                                subtype = Validity.Status.special;
                                break block0;
                            }
                        }
                        switch (subtype) {
                            case private_use: {
                                if (code.compareTo("Qaaq") >= 0) break;
                                subtype = Validity.Status.reserved;
                                break;
                            }
                            case regular: {
                                ScriptMetadata.Info scriptInfo = ScriptMetadata.getInfo(code);
                                if (scriptInfo != null || VARIANTS.contains(code)) break;
                                skippedScripts.add(code);
                                continue block24;
                            }
                        }
                        break;
                    }
                    case variant: {
                        if (!VARIANT_EXTRAS.contains(code)) break;
                        continue block24;
                    }
                }
                info.put(code, subtype);
            }
        }
        System.out.println("Skipping non-Unicode scripts: " + Joiner.on(' ').join(skippedScripts));
    }

    static class Info {
        String mainComment;
        Map<String, Validity.Status> codeToStatus = new TreeMap<String, Validity.Status>();
        Map<Validity.Status, String> statusComment = new EnumMap<Validity.Status, String>(Validity.Status.class);
        Set<String> newCodes = new TreeSet<String>();
        static Map<String, Info> types = new LinkedHashMap<String, Info>();

        Info() {
        }

        static Info getInfo(String myType) {
            Info info = types.get(myType);
            if (info == null) {
                info = new Info();
                types.put(myType, info);
            }
            return info;
        }

        public SetMultimap<Validity.Status, String> getStatusMap() {
            TreeMultimap result = TreeMultimap.create();
            Multimaps.invertFrom(Multimaps.forMap(this.codeToStatus), result);
            return ImmutableSetMultimap.copyOf(result);
        }

        public void put(String key, Validity.Status value) {
            this.codeToStatus.put(key, value);
        }

        public void remove(String key, Validity.Status value) {
            this.codeToStatus.remove(key, (Object)value);
        }

        public void clear() {
            this.codeToStatus.clear();
        }

        public Set<Map.Entry<String, Validity.Status>> entrySet() {
            return this.codeToStatus.entrySet();
        }

        public Validity.Status get(String key) {
            return this.codeToStatus.get(key);
        }

        public void putBest(String currency, Validity.Status newStatus) {
            Validity.Status oldStatus = this.get(currency);
            if (oldStatus == null || newStatus.compareTo(oldStatus) < 0) {
                this.put(currency, newStatus);
            }
        }
    }

    private static class MyAdder
    implements StringRange.Adder {
        Appendable target;
        boolean twoCodePoints = false;
        long lastCodePoint = -1L;

        private MyAdder() {
        }

        @Override
        public void add(String start, String end) {
            try {
                long firstCodePoint = start.codePointAt(0);
                if (this.twoCodePoints) {
                    firstCodePoint <<= 22;
                    firstCodePoint |= (long)start.codePointAt(1);
                }
                if (firstCodePoint == this.lastCodePoint) {
                    this.target.append(' ');
                } else {
                    this.target.append("\n\t\t\t");
                }
                this.target.append(start);
                if (end != null) {
                    this.target.append('~').append(end);
                }
                this.lastCodePoint = firstCodePoint;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        public void reset(boolean b) {
            this.lastCodePoint = -1L;
            this.twoCodePoints = b;
        }
    }
}

