/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.ibm.icu.impl.UnicodeRegex;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public final class MatcherList {
    private static final Joiner MULTI_JOINER = Joiner.on("\u00a7\u00a7");
    private static final Splitter MULTI_SPLITTER = Splitter.on("\u00a7\u00a7");
    private final List<MatcherIncludeExclude> list;

    private MatcherList(List<MatcherIncludeExclude> list) {
        this.list = ImmutableList.copyOf(list);
    }

    public static MatcherList from(String property) {
        if (property == null) {
            return null;
        }
        ArrayList<MatcherIncludeExclude> _result = new ArrayList<MatcherIncludeExclude>();
        for (String item : MULTI_SPLITTER.split(property)) {
            boolean include = true;
            if (item.startsWith("!")) {
                include = false;
                item = item.substring(1);
            }
            Matcher matcher = UnicodeRegex.compile(item).matcher("");
            _result.add(new MatcherIncludeExclude(matcher, include));
        }
        return new MatcherList(_result);
    }

    public synchronized boolean find(String s2) {
        for (MatcherIncludeExclude item : this.list) {
            boolean haveMatch = item.matcher.reset(s2).find();
            if (haveMatch == item.include) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean matches(String s2) {
        for (MatcherIncludeExclude item : this.list) {
            boolean haveMatch = item.matcher.reset(s2).matches();
            if (haveMatch == item.include) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MULTI_JOINER.join(this.list);
    }

    public static void main(String[] args) {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"abc\u00a7\u00a7!def", "abc and def", "false"}, {"abc\u00a7\u00a7!def", "abc and qrs", "true"}}) {
            boolean expected;
            MatcherList matcherList = MatcherList.from(test[0]);
            boolean actual = matcherList.find(test[1]);
            if (actual == (expected = Boolean.parseBoolean(test[2]))) continue;
            System.out.println("Failed");
            matcherList.find(test[1]);
        }
    }

    private static final class MatcherIncludeExclude {
        final Matcher matcher;
        final boolean include;

        private MatcherIncludeExclude(Matcher matcher, boolean include) {
            this.matcher = matcher;
            this.include = include;
        }

        public String toString() {
            return (this.include ? "" : "!") + this.matcher.pattern().toString();
        }
    }
}

