/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DTD2XSD {
    public static void write(DtdData data, DtdType type) {
        String dtdPath = CLDRPaths.BASE_DIRECTORY + type.dtdPath;
        String xsdPath = CLDRPaths.BASE_DIRECTORY + type.getXsdPath();
        DTD2XSD.writeXsd(type, data, dtdPath, xsdPath);
        System.err.println("Wrote XSD: " + xsdPath);
    }

    private static void writeXsd(DtdType type, DtdData data, String dtdPath, String xsdPath) {
        DtdInputFormat inFormat = new DtdInputFormat();
        XsdOutputFormat outputFormat = new XsdOutputFormat();
        ErrorHandlerImpl eh = new ErrorHandlerImpl();
        String inputUri = new File(dtdPath).toURI().toString();
        String[] params = new String[]{};
        try {
            SchemaCollection sc = inFormat.load(inputUri, params, "xsd", eh, null);
            outputFormat.output(sc, new LocalOutputDirectory(inputUri, new File(xsdPath), ".xsd", "UTF-8", 72, 2), params, "dtd", eh);
        }
        catch (InputFailedException | OutputFailedException | InvalidParamsException | IOException | SAXException e) {
            e.printStackTrace();
            System.err.println("Error generating XSD from " + inputUri);
        }
        Document d = LDMLUtilities.parse(xsdPath, false, false);
        DTD2XSD.removeAnnotationComments(null, d);
        try (BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(xsdPath, false));
             PrintWriter pw = new PrintWriter(file, false, StandardCharsets.UTF_8);){
            LDMLUtilities.printDOMTree(d, pw, null, "<!--\nNote: The .xsd files are a Technology Preview. They are subject to change or removal in future CLDR versions.\nNote: DTD @-annotations are not currently converted to .xsd. For full CLDR file validation, use the DTD and CLDR tools.\n-->\n\n");
        }
        catch (Throwable t2) {
            throw new RuntimeException("Generating .xsd for " + String.valueOf((Object)type), t2);
        }
    }

    static void removeAnnotationComments(Node parent, Node n) {
        if (parent != null && n.getNodeType() == 8) {
            if (n.getTextContent().trim().startsWith("@")) {
                parent.removeChild(n);
            }
        } else {
            NodeList nl = n.getChildNodes();
            if (nl != null) {
                for (int i = nl.getLength() - 1; i > 0; --i) {
                    DTD2XSD.removeAnnotationComments(n, nl.item(i));
                }
            }
        }
    }
}

